/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.openrdf.http.client.HttpClientDependent;
import org.openrdf.http.client.SesameClient;
import org.openrdf.http.client.SesameClientDependent;
import org.openrdf.http.client.SesameClientImpl;
import org.openrdf.http.client.SesameSession;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.Literals;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryBase;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.rio.RDFFormat;

public class HTTPRepository
extends RepositoryBase
implements HttpClientDependent,
SesameClientDependent {
    private SesameClient client;
    private SesameClientImpl dependentClient;
    private String username;
    private String password;
    private String serverURL;
    private String repositoryURL;
    private RDFFormat rdfFormat;
    private TupleQueryResultFormat tupleFormat;
    private File dataDir;
    private Boolean compatibleMode = null;

    private HTTPRepository() {
    }

    public HTTPRepository(String serverURL, String repositoryID) {
        this();
        this.serverURL = serverURL;
        this.repositoryURL = Protocol.getRepositoryLocation((String)serverURL, (String)repositoryID);
    }

    public HTTPRepository(String repositoryURL) {
        this();
        Pattern urlPattern = Pattern.compile("(.*)/repositories/[^/]*/?");
        Matcher matcher = urlPattern.matcher(repositoryURL);
        if (!matcher.matches() || matcher.groupCount() != 1) {
            throw new IllegalArgumentException("URL must be to a Sesame Repository (not just the server)");
        }
        this.serverURL = matcher.group(1);
        this.repositoryURL = repositoryURL;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    public synchronized SesameClient getSesameClient() {
        if (this.client == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        return this.client;
    }

    public synchronized void setSesameClient(SesameClient client) {
        this.client = client;
    }

    public final HttpClient getHttpClient() {
        return this.getSesameClient().getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        if (this.dependentClient == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        this.dependentClient.setHttpClient(httpClient);
    }

    public ValueFactory getValueFactory() {
        return ValueFactoryImpl.getInstance();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        return new HTTPRepositoryConnection(this, this.createHTTPClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWritable() throws RepositoryException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("HTTPRepository not initialized.");
        }
        boolean isWritable = false;
        String repositoryURL = this.createHTTPClient().getRepositoryURL();
        try {
            TupleQueryResult repositoryList = this.createHTTPClient().getRepositoryList();
            try {
                while (repositoryList.hasNext()) {
                    BindingSet bindingSet = (BindingSet)repositoryList.next();
                    Value uri = bindingSet.getValue("uri");
                    if (uri == null || !uri.stringValue().equals(repositoryURL)) continue;
                    isWritable = Literals.getBooleanValue((Value)bindingSet.getValue("writable"), (boolean)false);
                    break;
                }
            }
            finally {
                repositoryList.close();
            }
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        return isWritable;
    }

    public void setPreferredTupleQueryResultFormat(TupleQueryResultFormat format) {
        this.tupleFormat = format;
    }

    public TupleQueryResultFormat getPreferredTupleQueryResultFormat() {
        return this.tupleFormat;
    }

    public void setPreferredRDFFormat(RDFFormat format) {
        this.rdfFormat = format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.rdfFormat;
    }

    public void setUsernameAndPassword(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    protected void initializeInternal() throws RepositoryException {
    }

    protected void shutDownInternal() throws RepositoryException {
        if (this.dependentClient != null) {
            this.dependentClient.shutDown();
            this.dependentClient = null;
        }
        this.client = null;
    }

    protected SesameSession createHTTPClient() {
        SesameSession httpClient = this.getSesameClient().createSesameSession(this.serverURL);
        httpClient.setValueFactory((ValueFactory)ValueFactoryImpl.getInstance());
        if (this.repositoryURL != null) {
            httpClient.setRepository(this.repositoryURL);
        }
        if (this.tupleFormat != null) {
            httpClient.setPreferredTupleQueryResultFormat(this.tupleFormat);
        }
        if (this.rdfFormat != null) {
            httpClient.setPreferredRDFFormat(this.rdfFormat);
        }
        if (this.username != null) {
            httpClient.setUsernameAndPassword(this.username, this.password);
        }
        return httpClient;
    }

    synchronized boolean useCompatibleMode() throws RepositoryException {
        if (this.compatibleMode == null) {
            try {
                String serverProtocolVersion = this.createHTTPClient().getServerProtocol();
                this.compatibleMode = Integer.parseInt(serverProtocolVersion) < 7;
            }
            catch (NumberFormatException e) {
                throw new RepositoryException("could not read protocol version from server: ", (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("could not read protocol version from server: ", (Throwable)e);
            }
        }
        return this.compatibleMode;
    }
}

