/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.SparqlSession;
import org.openrdf.http.client.query.AbstractHTTPQuery;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPQueryEvaluationException;
import org.openrdf.repository.http.HTTPRepositoryConnection;

public class HTTPTupleQuery
extends AbstractHTTPQuery
implements TupleQuery {
    private final HTTPRepositoryConnection conn;

    public HTTPTupleQuery(HTTPRepositoryConnection conn, QueryLanguage ql, String queryString, String baseURI) {
        super((SparqlSession)conn.getSesameSession(), ql, queryString, baseURI);
        this.conn = conn;
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            return client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        SparqlSession client = this.getHttpClient();
        try {
            this.conn.flushTransactionState(Protocol.Action.QUERY);
            client.sendTupleQuery(this.queryLanguage, this.queryString, this.baseURI, this.dataset, this.includeInferred, this.getMaxExecutionTime(), handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (RepositoryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
        catch (MalformedQueryException e) {
            throw new HTTPQueryEvaluationException(e.getMessage(), e);
        }
    }
}

