/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.http;

import java.io.IOException;
import org.openrdf.http.client.SparqlSession;
import org.openrdf.http.client.query.AbstractHTTPUpdate;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepositoryConnection;
import org.openrdf.repository.http.HTTPUpdateExecutionException;

public class HTTPUpdate
extends AbstractHTTPUpdate {
    private final HTTPRepositoryConnection httpCon;

    public HTTPUpdate(HTTPRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super((SparqlSession)con.getSesameSession(), ql, queryString, baseURI);
        this.httpCon = con;
    }

    public void execute() throws UpdateExecutionException {
        try {
            if (this.httpCon.getRepository().useCompatibleMode()) {
                if (this.httpCon.isAutoCommit()) {
                    SparqlSession client = this.getHttpClient();
                    try {
                        client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getBindingsArray());
                    }
                    catch (UnauthorizedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (QueryInterruptedException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (MalformedQueryException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                    catch (IOException e) {
                        throw new HTTPUpdateExecutionException(e.getMessage(), e);
                    }
                } else {
                    this.httpCon.scheduleUpdate(this);
                }
                return;
            }
            SparqlSession client = this.getHttpClient();
            try {
                this.httpCon.flushTransactionState(Protocol.Action.UPDATE);
                client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getBindingsArray());
            }
            catch (UnauthorizedException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
            catch (QueryInterruptedException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
            catch (MalformedQueryException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new HTTPUpdateExecutionException(e.getMessage(), e);
            }
        }
        catch (RepositoryException e) {
            throw new HTTPUpdateExecutionException(e.getMessage(), e);
        }
    }
}

