/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc;

import java.util.List;
import org.openrdf.IsolationLevel;
import org.openrdf.IsolationLevels;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.UnknownSailTransactionStateException;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.inferencer.InferencerConnectionWrapper;
import org.openrdf.sail.model.SailModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForwardChainingInferencerConnection
extends InferencerConnectionWrapper
implements SailConnectionListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Sail sail;
    private boolean statementsRemoved;
    private Model newStatements;
    protected int totalInferred;

    public AbstractForwardChainingInferencerConnection(Sail sail, InferencerConnection con) {
        super(con);
        this.sail = sail;
        con.addConnectionListener(this);
    }

    public void statementAdded(Statement st) {
        if (this.statementsRemoved) {
            return;
        }
        if (this.newStatements == null) {
            this.newStatements = this.createModel();
        }
        this.newStatements.add((Object)st);
    }

    protected abstract Model createModel();

    public void statementRemoved(Statement st) {
        this.statementsRemoved = true;
        this.newStatements = null;
    }

    @Override
    public void flushUpdates() throws SailException {
        super.flushUpdates();
        if (this.statementsRemoved) {
            this.logger.debug("statements removed, starting inferencing from scratch");
            this.clearInferred(new Resource[0]);
            this.addAxiomStatements();
            this.newStatements = new SailModel((SailConnection)this.getWrappedConnection(), true);
            this.statementsRemoved = false;
        }
        if (this.hasNewStatements()) {
            this.doInferencing();
        }
        this.newStatements = null;
    }

    public void begin() throws SailException {
        this.begin(null);
    }

    public void begin(IsolationLevel level) throws SailException {
        IsolationLevel compatibleLevel;
        if (level == null) {
            level = this.sail.getDefaultIsolationLevel();
        }
        if ((compatibleLevel = IsolationLevels.getCompatibleIsolationLevel((IsolationLevel)level, (List)this.sail.getSupportedIsolationLevels())) == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + level + " not compatible with this Sail");
        }
        super.begin(compatibleLevel);
    }

    public void rollback() throws SailException {
        super.rollback();
        this.statementsRemoved = false;
        this.newStatements = null;
    }

    protected abstract void addAxiomStatements() throws SailException;

    protected void doInferencing() throws SailException {
        this.totalInferred = 0;
        int iteration = 0;
        while (this.hasNewStatements()) {
            this.logger.debug("starting iteration " + ++iteration);
            Model newThisIteration = this.prepareIteration();
            int nofInferred = this.applyRules(newThisIteration);
            this.logger.debug("iteration " + iteration + " done; inferred " + nofInferred + " new statements");
            this.totalInferred += nofInferred;
        }
    }

    protected abstract int applyRules(Model var1) throws SailException;

    protected Model prepareIteration() {
        Model newThisIteration = this.newStatements;
        this.newStatements = null;
        return newThisIteration;
    }

    protected boolean hasNewStatements() {
        return this.newStatements != null && !this.newStatements.isEmpty();
    }
}

