/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolverImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.rdbms.RdbmsConnectionFactory;
import org.openrdf.sail.rdbms.RdbmsProvider;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;

@Deprecated
public class RdbmsStore
extends SailBase
implements FederatedServiceResolverClient {
    private RdbmsConnectionFactory factory;
    private String jdbcDriver;
    private String url;
    private String user;
    private String password;
    private int maxTripleTables;
    private boolean triplesIndexed = true;
    private boolean sequenced = true;
    private BasicDataSource ds;
    private FederatedServiceResolver serviceResolver;
    private FederatedServiceResolverImpl dependentServiceResolver;

    public RdbmsStore() {
    }

    public RdbmsStore(String url) {
        this.url = url;
    }

    public RdbmsStore(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public RdbmsStore(String jdbcDriver, String jdbcUrl) {
        this.jdbcDriver = jdbcDriver;
        this.url = jdbcUrl;
    }

    public RdbmsStore(String jdbcDriver, String jdbcUrl, String user, String password) {
        this.jdbcDriver = jdbcDriver;
        this.url = jdbcUrl;
        this.user = user;
        this.password = password;
    }

    public int getMaxNumberOfTripleTables() {
        return this.maxTripleTables;
    }

    public void setMaxNumberOfTripleTables(int max) {
        this.maxTripleTables = max;
    }

    public boolean isIndexed() {
        return this.triplesIndexed;
    }

    public void setIndexed(boolean indexed) throws SailException {
        this.triplesIndexed = indexed;
        if (this.factory != null) {
            this.factory.setTriplesIndexed(this.triplesIndexed);
        }
    }

    public boolean isSequenced() {
        return this.sequenced;
    }

    public void setSequenced(boolean useSequence) {
        this.sequenced = useSequence;
    }

    public synchronized FederatedServiceResolver getFederatedServiceResolver() {
        if (this.serviceResolver == null) {
            if (this.dependentServiceResolver == null) {
                this.dependentServiceResolver = new FederatedServiceResolverImpl();
            }
            this.serviceResolver = this.dependentServiceResolver;
            return this.serviceResolver;
        }
        return this.serviceResolver;
    }

    public synchronized void setFederatedServiceResolver(FederatedServiceResolver reslover) {
        this.serviceResolver = reslover;
    }

    protected void initializeInternal() throws SailException {
        if (this.factory == null) {
            try {
                this.factory = this.createFactory(this.jdbcDriver, this.url, this.user, this.password);
            }
            catch (SailException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RdbmsException(e);
            }
        }
        this.factory.setMaxNumberOfTripleTables(this.maxTripleTables);
        this.factory.setTriplesIndexed(this.triplesIndexed);
        this.factory.setSequenced(this.sequenced);
        this.factory.init();
    }

    public boolean isWritable() throws SailException {
        return this.factory.isWritable();
    }

    public RdbmsValueFactory getValueFactory() {
        return this.factory.getValueFactory();
    }

    protected SailConnection getConnectionInternal() throws SailException {
        return this.factory.createConnection();
    }

    protected void shutDownInternal() throws SailException {
        this.factory.shutDown();
        try {
            if (this.ds != null) {
                this.ds.close();
            }
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        finally {
            if (this.dependentServiceResolver != null) {
                this.dependentServiceResolver.shutDown();
            }
        }
    }

    protected void setConnectionFactory(RdbmsConnectionFactory factory) {
        this.factory = factory;
    }

    protected void setBasicDataSource(BasicDataSource ds) {
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RdbmsConnectionFactory createFactory(String jdbcDriver, String url, String user, String password) throws Exception {
        if (jdbcDriver != null) {
            Class.forName(jdbcDriver);
        }
        DataSource ds = this.lookupDataSource(url, user, password);
        Connection con = user == null || url.startsWith("jdbc:") ? ds.getConnection() : ds.getConnection(user, password);
        try {
            DatabaseMetaData metaData = con.getMetaData();
            RdbmsConnectionFactory factory = this.newFactory(metaData);
            factory.setSail(this);
            if (user == null || url.startsWith("jdbc:")) {
                factory.setDataSource(ds);
            } else {
                factory.setDataSource(ds, user, password);
            }
            RdbmsConnectionFactory rdbmsConnectionFactory = factory;
            return rdbmsConnectionFactory;
        }
        finally {
            con.close();
        }
    }

    private DataSource lookupDataSource(String url, String user, String password) throws NamingException {
        if (url.startsWith("jdbc:")) {
            BasicDataSource ds = new BasicDataSource();
            ds.setUrl(url);
            ds.setUsername(user);
            ds.setPassword(password);
            this.setBasicDataSource(ds);
            return ds;
        }
        return (DataSource)new InitialContext().lookup(url);
    }

    private RdbmsConnectionFactory newFactory(DatabaseMetaData metaData) throws SQLException {
        String dbn = metaData.getDatabaseProductName();
        String dbv = metaData.getDatabaseProductVersion();
        Iterator<RdbmsProvider> providers = ServiceRegistry.lookupProviders(RdbmsProvider.class);
        while (providers.hasNext()) {
            RdbmsProvider provider = providers.next();
            RdbmsConnectionFactory factory = provider.createRdbmsConnectionFactory(dbn, dbv);
            if (factory == null) continue;
            return factory;
        }
        return new RdbmsConnectionFactory();
    }
}

