/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms;

import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.WritePrefReadWriteLockManager;
import java.sql.SQLException;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryBase;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.exceptions.RdbmsRuntimeException;
import org.openrdf.sail.rdbms.managers.BNodeManager;
import org.openrdf.sail.rdbms.managers.LiteralManager;
import org.openrdf.sail.rdbms.managers.PredicateManager;
import org.openrdf.sail.rdbms.managers.UriManager;
import org.openrdf.sail.rdbms.model.RdbmsBNode;
import org.openrdf.sail.rdbms.model.RdbmsLiteral;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.model.RdbmsStatement;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.schema.IdSequence;

public class RdbmsValueFactory
extends ValueFactoryBase {
    @Deprecated
    public static final String NIL_LABEL = "nil";
    private ValueFactory vf;
    private BNodeManager bnodes;
    private UriManager uris;
    private LiteralManager literals;
    private PredicateManager predicates;
    private WritePrefReadWriteLockManager lock = new WritePrefReadWriteLockManager();
    private IdSequence ids;

    public void setIdSequence(IdSequence ids) {
        this.ids = ids;
    }

    public void setBNodeManager(BNodeManager bnodes) {
        this.bnodes = bnodes;
    }

    public void setURIManager(UriManager uris) {
        this.uris = uris;
    }

    public void setLiteralManager(LiteralManager literals) {
        this.literals = literals;
    }

    public void setPredicateManager(PredicateManager predicates) {
        this.predicates = predicates;
    }

    public void setDelegate(ValueFactory vf) {
        this.vf = vf;
    }

    public void flush() throws RdbmsException {
        try {
            this.bnodes.flush();
            this.uris.flush();
            this.literals.flush();
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        catch (InterruptedException e) {
            throw new RdbmsException(e);
        }
    }

    public RdbmsBNode createBNode(String nodeID) {
        RdbmsBNode resource = (RdbmsBNode)this.bnodes.findInCache(nodeID);
        if (resource == null) {
            try {
                BNode impl = this.vf.createBNode(nodeID);
                resource = new RdbmsBNode(impl);
                this.bnodes.cache(resource);
            }
            catch (InterruptedException e) {
                throw new RdbmsRuntimeException(e);
            }
        }
        return resource;
    }

    public RdbmsLiteral createLiteral(String label) {
        return this.asRdbmsLiteral(this.vf.createLiteral(label, XMLSchema.STRING));
    }

    public RdbmsLiteral createLiteral(String label, String language) {
        return this.asRdbmsLiteral(this.vf.createLiteral(label, language));
    }

    public RdbmsLiteral createLiteral(String label, URI datatype) {
        return this.asRdbmsLiteral(this.vf.createLiteral(label, datatype));
    }

    public RdbmsStatement createStatement(Resource subject, URI predicate, Value object) {
        return this.createStatement(subject, predicate, object, null);
    }

    public RdbmsStatement createStatement(Resource subject, URI predicate, Value object, Resource context) {
        RdbmsResource subj = this.asRdbmsResource(subject);
        RdbmsURI pred = this.asRdbmsURI(predicate);
        RdbmsValue obj = this.asRdbmsValue(object);
        RdbmsResource ctx = this.asRdbmsResource(context);
        return new RdbmsStatement(subj, pred, obj, ctx);
    }

    public RdbmsURI createURI(String uri) {
        RdbmsURI resource = (RdbmsURI)this.uris.findInCache(uri);
        if (resource == null) {
            try {
                URI impl = this.vf.createURI(uri);
                resource = new RdbmsURI(impl);
                this.uris.cache(resource);
            }
            catch (InterruptedException e) {
                throw new RdbmsRuntimeException(e);
            }
        }
        return resource;
    }

    public RdbmsURI createURI(String namespace, String localName) {
        return this.createURI(namespace + localName);
    }

    public RdbmsResource getRdbmsResource(Number num, String stringValue) {
        assert (stringValue != null) : "Null stringValue for ID: " + num;
        Number id = this.ids.idOf(num);
        if (this.ids.isURI(id)) {
            return new RdbmsURI(id, this.uris.getIdVersion(), this.vf.createURI(stringValue));
        }
        return new RdbmsBNode(id, this.bnodes.getIdVersion(), this.vf.createBNode(stringValue));
    }

    public RdbmsLiteral getRdbmsLiteral(Number num, String label, String language, String datatype) {
        Number id = this.ids.idOf(num);
        if (datatype == null && language == null) {
            return new RdbmsLiteral(id, this.literals.getIdVersion(), this.vf.createLiteral(label));
        }
        if (datatype == null) {
            return new RdbmsLiteral(id, this.literals.getIdVersion(), this.vf.createLiteral(label, language));
        }
        return new RdbmsLiteral(id, this.literals.getIdVersion(), this.vf.createLiteral(label, this.vf.createURI(datatype)));
    }

    public RdbmsResource asRdbmsResource(Resource node) {
        if (node == null) {
            return null;
        }
        if (node instanceof URI) {
            return this.asRdbmsURI((URI)node);
        }
        if (node instanceof RdbmsBNode) {
            try {
                this.bnodes.cache((RdbmsBNode)node);
                return (RdbmsBNode)node;
            }
            catch (InterruptedException e) {
                throw new RdbmsRuntimeException(e);
            }
        }
        return this.createBNode(((BNode)node).getID());
    }

    public RdbmsURI asRdbmsURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri instanceof RdbmsURI) {
            try {
                this.uris.cache((RdbmsURI)uri);
                return (RdbmsURI)uri;
            }
            catch (InterruptedException e) {
                throw new RdbmsRuntimeException(e);
            }
        }
        return this.createURI(uri.stringValue());
    }

    public RdbmsValue asRdbmsValue(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Literal) {
            return this.asRdbmsLiteral((Literal)value);
        }
        return this.asRdbmsResource((Resource)value);
    }

    public RdbmsLiteral asRdbmsLiteral(Literal literal) {
        try {
            if (literal instanceof RdbmsLiteral) {
                this.literals.cache((RdbmsLiteral)literal);
                return (RdbmsLiteral)literal;
            }
            RdbmsLiteral lit = (RdbmsLiteral)this.literals.findInCache(literal);
            if (lit == null) {
                lit = new RdbmsLiteral(literal);
                this.literals.cache(lit);
            }
            return lit;
        }
        catch (InterruptedException e) {
            throw new RdbmsRuntimeException(e);
        }
    }

    public RdbmsResource[] asRdbmsResource(Resource ... contexts) {
        RdbmsResource[] ctxs = new RdbmsResource[contexts.length];
        for (int i = 0; i < ctxs.length; ++i) {
            ctxs[i] = this.asRdbmsResource(contexts[i]);
        }
        return ctxs;
    }

    public RdbmsStatement asRdbmsStatement(Statement stmt) {
        if (stmt instanceof RdbmsStatement) {
            return (RdbmsStatement)stmt;
        }
        Resource s = stmt.getSubject();
        URI p = stmt.getPredicate();
        Value o = stmt.getObject();
        Resource c = stmt.getContext();
        return this.createStatement(s, p, o, c);
    }

    public Number getInternalId(Value r) throws RdbmsException {
        try {
            if (r == null) {
                return 0L;
            }
            RdbmsValue value = this.asRdbmsValue(r);
            if (value instanceof RdbmsURI) {
                return this.uris.getInternalId((RdbmsURI)value);
            }
            if (value instanceof RdbmsBNode) {
                return this.bnodes.getInternalId((RdbmsBNode)value);
            }
            return this.literals.getInternalId((RdbmsLiteral)value);
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        catch (InterruptedException e) {
            throw new RdbmsRuntimeException(e);
        }
    }

    public Number getPredicateId(RdbmsURI predicate) throws RdbmsException {
        try {
            return this.predicates.getIdOfPredicate(predicate);
        }
        catch (SQLException e) {
            throw new RdbmsException(e);
        }
        catch (InterruptedException e) {
            throw new RdbmsRuntimeException(e);
        }
    }

    public Lock getIdReadLock() throws InterruptedException {
        return this.lock.getReadLock();
    }

    public Lock tryIdWriteLock() {
        return this.lock.tryWriteLock();
    }

    public Lock getIdWriteLock() throws InterruptedException {
        return this.lock.getWriteLock();
    }
}

