/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.managers;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.sail.rdbms.managers.BNodeManager;
import org.openrdf.sail.rdbms.managers.LiteralManager;
import org.openrdf.sail.rdbms.managers.UriManager;
import org.openrdf.sail.rdbms.managers.base.ManagerBase;
import org.openrdf.sail.rdbms.model.RdbmsBNode;
import org.openrdf.sail.rdbms.model.RdbmsLiteral;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.schema.Batch;
import org.openrdf.sail.rdbms.schema.HashBatch;
import org.openrdf.sail.rdbms.schema.HashTable;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashManager
extends ManagerBase {
    public static HashManager instance;
    private static final boolean USE_THREAD = true;
    private Logger logger = LoggerFactory.getLogger(HashManager.class);
    private HashTable table;
    private Map<Long, Number> ids;
    private AtomicInteger version = new AtomicInteger();
    private BNodeManager bnodes;
    private UriManager uris;
    private LiteralManager literals;
    private Thread lookupThread;
    private Object assignIds = new Object();
    private Object working = new Object();
    private BlockingQueue<RdbmsValue> queue;
    private IdSequence idseq;
    Exception exc;
    RdbmsValue closeSignal = new RdbmsValue(){
        private static final long serialVersionUID = -2211413309013905712L;

        public String stringValue() {
            return null;
        }
    };
    private RdbmsValue taken;

    public HashManager() {
        instance = this;
    }

    public void setHashTable(HashTable table) {
        this.table = table;
        this.ids = new HashMap<Long, Number>(table.getBatchSize());
    }

    public void setBNodeManager(BNodeManager bnodeTable) {
        this.bnodes = bnodeTable;
    }

    public void setLiteralManager(LiteralManager literalTable) {
        this.literals = literalTable;
    }

    public void setUriManager(UriManager uriTable) {
        this.uris = uriTable;
    }

    public void setIdSequence(IdSequence idseq) {
        this.idseq = idseq;
    }

    public void init() {
        this.queue = new ArrayBlockingQueue<RdbmsValue>(this.table.getBatchSize());
        this.lookupThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HashManager.this.lookupThread(HashManager.this.working, HashManager.this.assignIds);
                }
                catch (Exception e) {
                    HashManager.this.exc = e;
                    HashManager.this.logger.error(e.toString(), (Throwable)e);
                }
            }
        }, "id-lookup");
        this.lookupThread.start();
    }

    @Override
    public void close() throws SQLException {
        if (this.queue == null) {
            return;
        }
        try {
            this.flush();
            if (this.lookupThread != null) {
                this.queue.put(this.closeSignal);
                this.lookupThread.join();
            }
        }
        catch (InterruptedException e) {
            this.logger.warn(e.toString(), (Throwable)e);
        }
        super.close();
        this.table.close();
    }

    public int getIdVersion() {
        return this.version.intValue();
    }

    @Override
    public void optimize() throws SQLException {
        this.table.optimize();
    }

    public boolean removedStatements(int count, String condition) throws SQLException {
        if (this.table.expungeRemovedStatements(count, condition)) {
            this.version.addAndGet(1);
            return true;
        }
        return false;
    }

    public void lookupId(RdbmsValue value) throws InterruptedException {
        this.queue.put(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignId(RdbmsValue value, int version) throws InterruptedException, SQLException {
        ArrayList<RdbmsValue> values = new ArrayList<RdbmsValue>(this.getChunkSize());
        Iterator iterator = this.assignIds;
        synchronized (iterator) {
            this.throwException();
            if (value.isExpired(version)) {
                HashMap<Long, Number> map = new HashMap<Long, Number>(this.getChunkSize());
                values.add(value);
                this.assignIds(values, map);
            }
        }
        for (RdbmsValue v : values) {
            this.insert(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws SQLException, InterruptedException {
        Iterator iterator;
        this.throwException();
        ArrayList<RdbmsValue> values = new ArrayList<RdbmsValue>(this.getChunkSize());
        HashMap<Long, Number> map = new HashMap<Long, Number>(this.getChunkSize());
        RdbmsValue taken = (RdbmsValue)this.queue.poll();
        while (taken != null) {
            values.clear();
            values.add(taken);
            iterator = this.assignIds;
            synchronized (iterator) {
                this.assignIds(values, map);
            }
            for (RdbmsValue v : values) {
                this.insert(v);
            }
            taken = (RdbmsValue)this.queue.poll();
            if (taken != this.closeSignal) continue;
            this.queue.add(taken);
            taken = null;
        }
        iterator = this.working;
        synchronized (iterator) {
            values.clear();
            Iterator iterator2 = this.assignIds;
            synchronized (iterator2) {
                if (this.taken != null && this.taken != this.closeSignal) {
                    values.add(this.taken);
                    this.assignIds(values, map);
                    this.taken = null;
                }
            }
            for (RdbmsValue v : values) {
                this.insert(v);
            }
        }
        super.flush();
    }

    public String getExpungeCondition() {
        StringBuilder sb = new StringBuilder();
        sb.append("AND id NOT IN (SELECT id FROM ");
        sb.append(this.table.getName()).append(")");
        return sb.toString();
    }

    protected int getChunkSize() {
        return this.table.getSelectChunkSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush(Batch batch) throws SQLException {
        super.flush(batch);
        Object object = this.assignIds;
        synchronized (object) {
            Map<Long, Number> map = this.ids;
            synchronized (map) {
                HashBatch hb = (HashBatch)batch;
                for (Long hash : hb.getHashes()) {
                    this.ids.remove(hash);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lookupThread(Object working, Object assignIds) throws InterruptedException, SQLException {
        ArrayList<RdbmsValue> values = new ArrayList<RdbmsValue>(this.getChunkSize());
        HashMap<Long, Number> map = new HashMap<Long, Number>(this.getChunkSize());
        this.taken = this.queue.take();
        while (this.taken != this.closeSignal) {
            Object object = working;
            synchronized (object) {
                values.clear();
                Iterator iterator = assignIds;
                synchronized (iterator) {
                    if (this.taken != null) {
                        values.add(this.taken);
                        this.assignIds(values, map);
                        this.taken = null;
                    }
                }
                for (RdbmsValue v : values) {
                    this.insert(v);
                }
            }
            this.taken = this.queue.take();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignIds(List<RdbmsValue> values, Map<Long, Number> map) throws SQLException, InterruptedException {
        while (values.size() < this.getChunkSize()) {
            RdbmsValue taken = (RdbmsValue)this.queue.poll();
            if (taken == this.closeSignal) {
                this.queue.add(taken);
                break;
            }
            if (taken == null) break;
            values.add(taken);
        }
        Map<Long, Number> existing = this.lookup(values, map);
        Iterator<RdbmsValue> iter = values.iterator();
        while (iter.hasNext()) {
            RdbmsValue value = iter.next();
            Long hash = this.idseq.hashOf(value);
            if (existing.get(hash) != null) {
                Number id = this.idseq.idOf(existing.get(hash));
                value.setInternalId(id);
                value.setVersion(this.getIdVersion(value));
                iter.remove();
                continue;
            }
            Map<Long, Number> map2 = this.ids;
            synchronized (map2) {
                Number id;
                if (this.ids.containsKey(hash)) {
                    id = this.ids.get(hash);
                    value.setInternalId(id);
                    value.setVersion(this.getIdVersion(value));
                    iter.remove();
                } else {
                    id = this.idseq.nextId(value);
                    value.setInternalId(id);
                    value.setVersion(this.getIdVersion(value));
                    this.ids.put(hash, id);
                }
            }
        }
    }

    private Map<Long, Number> lookup(Collection<RdbmsValue> values, Map<Long, Number> map) throws SQLException {
        assert (!values.isEmpty());
        assert (values.size() <= this.getChunkSize());
        map.clear();
        for (RdbmsValue value : values) {
            map.put(this.idseq.hashOf(value), null);
        }
        return this.table.load(map);
    }

    private Integer getIdVersion(RdbmsValue value) {
        if (value instanceof RdbmsLiteral) {
            return this.literals.getIdVersion();
        }
        if (value instanceof RdbmsURI) {
            return this.uris.getIdVersion();
        }
        assert (value instanceof RdbmsBNode);
        return this.bnodes.getIdVersion();
    }

    private void insert(RdbmsValue value) throws SQLException, InterruptedException {
        Number id = value.getInternalId();
        this.table.insert(id, this.idseq.hashOf(value));
        if (value instanceof RdbmsLiteral) {
            this.literals.insert(id, (RdbmsLiteral)value);
        } else if (value instanceof RdbmsURI) {
            this.uris.insert(id, (RdbmsURI)value);
        } else {
            assert (value instanceof RdbmsBNode);
            this.bnodes.insert(id, (RdbmsBNode)value);
        }
    }

    private void throwException() throws SQLException {
        if (this.exc instanceof SQLException) {
            SQLException e = (SQLException)this.exc;
            this.exc = null;
            throw e;
        }
        if (this.exc instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)this.exc;
            this.exc = null;
            throw e;
        }
    }
}

