/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangePackaging
extends Recipe {
    private static final XPathMatcher PROJECT_MATCHER = new XPathMatcher("/project");
    @Option(displayName="Group", description="The groupId of the project whose packaging should be changed. Accepts glob patterns.", example="org.openrewrite.*")
    private final String groupId;
    @Option(displayName="Group", description="The artifactId of the project whose packaging should be changed. Accepts glob patterns.", example="rewrite-*")
    private final String artifactId;
    @Option(displayName="Packaging", description="The type of packaging to set. If `null` specified the packaging tag will be removed", example="jar")
    @Nullable
    private final String packaging;
    @Option(displayName="Old Packaging", description="The old packaging type. If provided, will only change if the current packaging matches", required=false, example="jar")
    @Nullable
    private final String oldPackaging;

    public String getDisplayName() {
        return "Set Maven project packaging";
    }

    public String getInstanceNameSuffix() {
        return String.format("for `%s:%s` to `%s`", this.groupId, this.artifactId, this.packaging);
    }

    public String getDescription() {
        return "Sets the packaging type of Maven projects. Either adds the packaging tag if it is missing or changes its context if present.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                ResolvedPom pom = this.getResolutionResult().getPom();
                if (!StringUtils.matchesGlob((String)pom.getGroupId(), (String)ChangePackaging.this.groupId) || !StringUtils.matchesGlob((String)pom.getArtifactId(), (String)ChangePackaging.this.artifactId)) {
                    return document;
                }
                Xml.Document xml = super.visitDocument(document, ctx);
                if (xml != document) {
                    return xml.withMarkers(xml.getMarkers().withMarkers(ListUtils.map((List)xml.getMarkers().getMarkers(), m -> {
                        if (m instanceof MavenResolutionResult) {
                            return this.getResolutionResult().withPom(pom.withRequested(pom.getRequested().withPackaging(ChangePackaging.this.packaging)));
                        }
                        return m;
                    })));
                }
                return xml;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional maybePackaging;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (PROJECT_MATCHER.matches(this.getCursor()) && (!(maybePackaging = t.getChild("packaging")).isPresent() || ChangePackaging.this.oldPackaging == null || ChangePackaging.this.oldPackaging.equals(((Xml.Tag)maybePackaging.get()).getValue().orElse(null)))) {
                    t = ChangePackaging.this.packaging == null || "jar".equals(ChangePackaging.this.packaging) ? FilterTagChildrenVisitor.filterTagChildren((Xml.Tag)t, it -> !"packaging".equals(it.getName())) : AddOrUpdateChild.addOrUpdateChild((Xml.Tag)t, (Xml.Tag)Xml.Tag.build((String)("\n<packaging>" + ChangePackaging.this.packaging + "</packaging>")), (Cursor)this.getCursor().getParentOrThrow());
                }
                return t;
            }
        };
    }

    @Generated
    public ChangePackaging(String groupId, String artifactId, @Nullable String packaging, @Nullable String oldPackaging) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.packaging = packaging;
        this.oldPackaging = oldPackaging;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    @Generated
    public String getPackaging() {
        return this.packaging;
    }

    @Nullable
    @Generated
    public String getOldPackaging() {
        return this.oldPackaging;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePackaging(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", packaging=" + this.getPackaging() + ", oldPackaging=" + this.getOldPackaging() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePackaging)) {
            return false;
        }
        ChangePackaging other = (ChangePackaging)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$packaging = this.getPackaging();
        String other$packaging = other.getPackaging();
        if (this$packaging == null ? other$packaging != null : !this$packaging.equals(other$packaging)) {
            return false;
        }
        String this$oldPackaging = this.getOldPackaging();
        String other$oldPackaging = other.getOldPackaging();
        return !(this$oldPackaging == null ? other$oldPackaging != null : !this$oldPackaging.equals(other$oldPackaging));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePackaging;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $packaging = this.getPackaging();
        result = result * 59 + ($packaging == null ? 43 : $packaging.hashCode());
        String $oldPackaging = this.getOldPackaging();
        result = result * 59 + ($oldPackaging == null ? 43 : $oldPackaging.hashCode());
        return result;
    }
}

