/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.cache.CaffeineCacheMetrics;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public class InMemoryMavenPomCache
implements MavenPomCache {
    private final Cache<ResolvedGroupArtifactVersion, Optional<Pom>> pomCache;
    private final Cache<MetadataKey, Optional<MavenMetadata>> mavenMetadataCache;
    private final Cache<MavenRepository, Optional<MavenRepository>> repositoryCache;
    private final Cache<ResolvedGroupArtifactVersion, ResolvedPom> dependencyCache;

    public InMemoryMavenPomCache() {
        this((Cache<ResolvedGroupArtifactVersion, Optional<Pom>>)Caffeine.newBuilder().recordStats().maximumSize(100000L).build(), (Cache<MetadataKey, Optional<MavenMetadata>>)Caffeine.newBuilder().recordStats().maximumSize(100000L).build(), (Cache<MavenRepository, Optional<MavenRepository>>)Caffeine.newBuilder().recordStats().maximumSize(10000L).build(), (Cache<ResolvedGroupArtifactVersion, ResolvedPom>)Caffeine.newBuilder().recordStats().maximumSize(100000L).build());
    }

    public InMemoryMavenPomCache(String cacheNickname, Cache<ResolvedGroupArtifactVersion, Optional<Pom>> pomCache, Cache<MetadataKey, Optional<MavenMetadata>> mavenMetadataCache, Cache<MavenRepository, Optional<MavenRepository>> repositoryCache, Cache<ResolvedGroupArtifactVersion, ResolvedPom> dependencyCache) {
        this.pomCache = CaffeineCacheMetrics.monitor((MeterRegistry)Metrics.globalRegistry, pomCache, (String)("Maven POMs - " + cacheNickname), (String[])new String[0]);
        this.mavenMetadataCache = CaffeineCacheMetrics.monitor((MeterRegistry)Metrics.globalRegistry, mavenMetadataCache, (String)("Maven metadata - " + cacheNickname), (String[])new String[0]);
        this.repositoryCache = CaffeineCacheMetrics.monitor((MeterRegistry)Metrics.globalRegistry, repositoryCache, (String)("Maven repositories - " + cacheNickname), (String[])new String[0]);
        this.dependencyCache = CaffeineCacheMetrics.monitor((MeterRegistry)Metrics.globalRegistry, dependencyCache, (String)("Resolved dependency POMs - " + cacheNickname), (String[])new String[0]);
    }

    public InMemoryMavenPomCache(Cache<ResolvedGroupArtifactVersion, Optional<Pom>> pomCache, Cache<MetadataKey, Optional<MavenMetadata>> mavenMetadataCache, Cache<MavenRepository, Optional<MavenRepository>> repositoryCache, Cache<ResolvedGroupArtifactVersion, ResolvedPom> dependencyCache) {
        this("default", pomCache, mavenMetadataCache, repositoryCache, dependencyCache);
    }

    @Override
    @Nullable
    public ResolvedPom getResolvedDependencyPom(ResolvedGroupArtifactVersion dependency) {
        return (ResolvedPom)this.dependencyCache.getIfPresent((Object)dependency);
    }

    @Override
    public void putResolvedDependencyPom(ResolvedGroupArtifactVersion dependency, ResolvedPom resolved) {
        this.dependencyCache.put((Object)dependency, (Object)resolved.deduplicate());
    }

    @Override
    @Nullable
    public Optional<MavenMetadata> getMavenMetadata(URI repo, GroupArtifactVersion gav) {
        return (Optional)this.mavenMetadataCache.getIfPresent((Object)new MetadataKey(repo, gav));
    }

    @Override
    public void putMavenMetadata(URI repo, GroupArtifactVersion gav, @Nullable MavenMetadata metadata) {
        this.mavenMetadataCache.put((Object)new MetadataKey(repo, gav), Optional.ofNullable(metadata));
    }

    @Override
    @Nullable
    public Optional<Pom> getPom(ResolvedGroupArtifactVersion gav) {
        return (Optional)this.pomCache.getIfPresent((Object)gav);
    }

    @Override
    public void putPom(ResolvedGroupArtifactVersion gav, @Nullable Pom pom) {
        this.pomCache.put((Object)gav, Optional.ofNullable(pom));
    }

    @Override
    @Nullable
    public Optional<MavenRepository> getNormalizedRepository(MavenRepository repository) {
        return (Optional)this.repositoryCache.getIfPresent((Object)repository);
    }

    @Override
    public void putNormalizedRepository(MavenRepository repository, MavenRepository normalized) {
        this.repositoryCache.put((Object)repository, Optional.ofNullable(normalized));
    }

    public static final class MetadataKey {
        private final URI repository;
        private final GroupArtifactVersion gav;

        @Generated
        public MetadataKey(URI repository, GroupArtifactVersion gav) {
            this.repository = repository;
            this.gav = gav;
        }

        @Generated
        public URI getRepository() {
            return this.repository;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetadataKey)) {
                return false;
            }
            MetadataKey other = (MetadataKey)o;
            URI this$repository = this.getRepository();
            URI other$repository = other.getRepository();
            if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
                return false;
            }
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            return !(this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $repository = this.getRepository();
            result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "InMemoryMavenPomCache.MetadataKey(repository=" + this.getRepository() + ", gav=" + this.getGav() + ")";
        }
    }
}

