/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenRepository;

public class MavenDownloadingException
extends Exception {
    @Nullable
    private GroupArtifactVersion root;
    private final GroupArtifactVersion failedOn;
    private Map<MavenRepository, String> repositoryResponses = Collections.emptyMap();

    public MavenDownloadingException setRoot(GroupArtifactVersion root) {
        this.root = root;
        return this;
    }

    public GroupArtifactVersion getRoot() {
        return this.root == null ? this.failedOn : this.root;
    }

    public MavenDownloadingException setRepositoryResponses(Map<MavenRepository, String> repositoryResponses) {
        this.repositoryResponses = repositoryResponses;
        return this;
    }

    public MavenDownloadingException(String message, @Nullable Throwable cause, GroupArtifactVersion failedOn) {
        super(message, cause);
        this.failedOn = failedOn;
    }

    @Override
    public String getMessage() {
        String message = "";
        if (!this.failedOn.equals(this.root)) {
            message = message + this.failedOn + " failed. ";
        }
        message = message + super.getMessage();
        if (!this.repositoryResponses.isEmpty()) {
            StringJoiner repos = new StringJoiner("\n");
            for (Map.Entry<MavenRepository, String> repoResponse : this.repositoryResponses.entrySet()) {
                repos.add(repoResponse.getKey().getUri() + ": " + repoResponse.getValue());
            }
            return message + " Tried repositories:\n" + repos;
        }
        return message;
    }

    public <T extends Tree> T warn(T t) {
        return (T)Markup.warn(t, (Throwable)this);
    }

    @Generated
    public GroupArtifactVersion getFailedOn() {
        return this.failedOn;
    }

    @Generated
    public Map<MavenRepository, String> getRepositoryResponses() {
        return this.repositoryResponses;
    }
}

