/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml.style;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindIndentYamlVisitor;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.tree.Yaml;

public class Autodetect {
    public static IndentsStyle tabsAndIndents(Yaml yaml, IndentsStyle orElse) {
        FindIndentYamlVisitor findIndent = new FindIndentYamlVisitor();
        findIndent.visit(yaml, 0);
        return findIndent.nonZeroIndents() > 0L ? new IndentsStyle(findIndent.getMostCommonIndent()) : orElse;
    }

    public static GeneralFormatStyle generalFormat(Yaml yaml) {
        FindLineFormatJavaVisitor findLineFormat = new FindLineFormatJavaVisitor();
        findLineFormat.visit((Tree)yaml, (Object)0);
        return new GeneralFormatStyle(!findLineFormat.isIndentedWithLFNewLines());
    }

    private static class FindLineFormatJavaVisitor<P>
    extends YamlIsoVisitor<P> {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private FindLineFormatJavaVisitor() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public @Nullable Yaml visit(@Nullable Tree tree, P p) {
            Yaml y = (Yaml)super.visit(tree, p);
            if (y != null) {
                if (y.getPrefix().startsWith("\r\n")) {
                    ++this.linesWithCRLFNewLines;
                } else if (y.getPrefix().startsWith("\n")) {
                    ++this.linesWithLFNewLines;
                }
            }
            return y;
        }
    }
}

