/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.resolve.TrustType;
import org.openxri.xml.ForwardingService;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class ProxyResolutionService
extends Service {
    public static final String SERVICE_TYPE = "xri://$res*proxy*($v*2.0)";
    public static final String[] SERVICE_MEDIA_TYPES = new String[]{"application/xrds+xml", "application/xrd+xml", "text/uri-list"};
    public static final String TRUST_TYPE_SEPARATOR = ";";
    public static final String REFS_SEPARATOR = ";";
    public static final String SEP_SEPARATOR = ";";
    public static final Integer URI_PRIORITY_HTTPS = new Integer(1);
    public static final Integer URI_PRIORITY_DEFAULT = new Integer(2);

    public ProxyResolutionService(URI[] proxies, String providerID, TrustType trustType, Boolean refs, Boolean sep) {
        int i;
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addType(new SEPType(SERVICE_TYPE, null, Boolean.TRUE));
        for (i = 0; i < SERVICE_MEDIA_TYPES.length; ++i) {
            String mediaType = SERVICE_MEDIA_TYPES[i];
            if (trustType != null && !trustType.equals("none")) {
                mediaType = mediaType + ";" + trustType.getParameterPair();
                if (refs != null) {
                    mediaType = mediaType + ";" + refs;
                }
                if (sep != null) {
                    mediaType = mediaType + ";" + sep;
                }
            }
            this.addMediaType(new SEPMediaType(mediaType, null, Boolean.FALSE));
        }
        for (i = 0; i < proxies.length; ++i) {
            URI resolver = proxies[i];
            try {
                Integer priority = resolver.getScheme().toLowerCase().equals("https") ? URI_PRIORITY_HTTPS : URI_PRIORITY_DEFAULT;
                this.addURI(new SEPUri(resolver.toString(), priority, "none"));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public ProxyResolutionService(URI proxy, String providerId, TrustType trustType, Boolean refs, Boolean sep) {
        this(new URI[]{proxy}, providerId, trustType, refs, sep);
    }

    public ProxyResolutionService(URI[] proxies, String providerId, TrustType trustType) {
        this(proxies, providerId, trustType, null, null);
    }

    public ProxyResolutionService(URI proxy, String providerId, TrustType trustType) {
        this(new URI[]{proxy}, providerId, trustType, null, null);
    }

    public ProxyResolutionService(URI[] proxies, String providerId) {
        this(proxies, providerId, null, null, null);
    }

    public ProxyResolutionService(URI proxy, String providerId) {
        this(new URI[]{proxy}, providerId, null, null, null);
    }

    public ProxyResolutionService(URI[] proxies) {
        this(proxies, null, null, null, null);
    }

    public ProxyResolutionService(URI proxy) {
        this(new URI[]{proxy}, null, null, null, null);
    }

    public static boolean isInstance(Service service) {
        if (service instanceof ForwardingService) {
            return true;
        }
        List serviceTypes = service.getTypes();
        for (int i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (!SERVICE_TYPE.equals(serviceType.getValue())) continue;
            return true;
        }
        return false;
    }
}

