/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.h2gis.utilities.Constants;

public class TableLocation {
    private String catalog;
    private String schema;
    private String table;
    private static final String QUOTE_CHAR = "\"";
    private static final Pattern POSTGRE_SPECIAL_NAME_PATTERN = Pattern.compile("[^a-z0-9_]");
    private static final Pattern H2_SPECIAL_NAME_PATTERN = Pattern.compile("[^A-Z0-9_]");
    private String defaultSchema = "PUBLIC";

    public TableLocation(ResultSet rs) throws SQLException {
        this(rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), rs.getString("TABLE_NAME"));
    }

    public TableLocation(String catalog, String schema, String table) {
        if (table == null) {
            throw new IllegalArgumentException("Cannot construct table location with null table");
        }
        this.catalog = catalog == null ? "" : catalog;
        this.schema = schema == null || schema.isEmpty() ? "" : schema;
        this.table = table;
    }

    public TableLocation(String schema, String table) {
        this("", schema, table);
    }

    public TableLocation(String table) {
        this("", table);
    }

    public static String quoteIdentifier(String identifier) {
        return QUOTE_CHAR + identifier.replace(QUOTE_CHAR, "\"\"") + QUOTE_CHAR;
    }

    public static String quoteIdentifier(String identifier, boolean isH2DataBase) {
        if (isH2DataBase && (Constants.H2_RESERVED_WORDS.contains(identifier.toUpperCase()) || H2_SPECIAL_NAME_PATTERN.matcher(identifier).find()) || !isH2DataBase && (Constants.POSTGIS_RESERVED_WORDS.contains(identifier.toUpperCase()) || POSTGRE_SPECIAL_NAME_PATTERN.matcher(identifier).find())) {
            return TableLocation.quoteIdentifier(identifier);
        }
        return identifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.catalog.isEmpty()) {
            sb.append(TableLocation.quoteIdentifier(this.catalog));
            sb.append(".");
        }
        if (!this.schema.isEmpty()) {
            sb.append(TableLocation.quoteIdentifier(this.schema));
            sb.append(".");
        }
        sb.append(TableLocation.quoteIdentifier(this.table));
        return sb.toString();
    }

    public String toString(boolean isH2) {
        StringBuilder sb = new StringBuilder();
        if (!this.catalog.isEmpty()) {
            sb.append(TableLocation.quoteIdentifier(this.catalog, isH2));
            sb.append(".");
        }
        if (!this.schema.isEmpty()) {
            sb.append(TableLocation.quoteIdentifier(this.schema, isH2));
            sb.append(".");
        }
        sb.append(TableLocation.quoteIdentifier(this.table, isH2));
        return sb.toString();
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getCatalog(String defaultValue) {
        return this.catalog.isEmpty() ? defaultValue : this.catalog;
    }

    public static TableLocation parse(String concatenatedTableLocation) {
        return TableLocation.parse(concatenatedTableLocation, null);
    }

    public static TableLocation parse(String concatenatedTableLocation, Boolean isH2Database) {
        LinkedList<String> parts = new LinkedList<String>();
        String schema = "";
        String table = "";
        String catalog = "";
        StringTokenizer st = new StringTokenizer(concatenatedTableLocation, ".`\"", true);
        boolean openQuote = false;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("`") || token.equals(QUOTE_CHAR)) {
                openQuote = !openQuote;
                continue;
            }
            if (token.equals(".")) {
                if (openQuote) {
                    sb.append(token);
                    continue;
                }
                parts.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (!openQuote && isH2Database != null) {
                token = TableLocation.capsIdentifier(token, isH2Database);
            }
            sb.append(token);
        }
        if (sb.length() != 0) {
            parts.add(sb.toString());
        }
        String[] values = parts.toArray(new String[parts.size()]);
        switch (values.length) {
            case 1: {
                table = values[0].trim();
                break;
            }
            case 2: {
                schema = values[0].trim();
                table = values[1].trim();
                break;
            }
            case 3: {
                catalog = values[0].trim();
                schema = values[1].trim();
                table = values[2].trim();
            }
        }
        return new TableLocation(catalog, schema, table);
    }

    public static String capsIdentifier(String identifier, Boolean isH2Database) {
        if (isH2Database != null) {
            if (isH2Database.booleanValue()) {
                return identifier.toUpperCase();
            }
            return identifier.toLowerCase();
        }
        return identifier;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSchema(String defaultValue) {
        return this.schema.isEmpty() ? defaultValue : this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableLocation)) {
            return false;
        }
        TableLocation that = (TableLocation)o;
        return (this.catalog.equals(that.catalog) || this.catalog.isEmpty() || that.catalog.isEmpty()) && (this.schema.equals(that.schema) || this.schema.equals(this.defaultSchema) && that.schema.isEmpty() || that.schema.equals(this.defaultSchema) && this.schema.isEmpty()) && this.table.equals(that.table);
    }

    public int hashCode() {
        int result = this.catalog.hashCode();
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.table.hashCode();
        return result;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }
}

