/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class URIUtility {
    public static final String ENCODING = "UTF-8";

    public static Map<String, String> getQueryKeyValuePairs(URI uri) throws UnsupportedEncodingException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        String query = uri.getRawQuery();
        if (query == null) {
            try {
                uri = URI.create(uri.getRawSchemeSpecificPart());
                query = uri.getRawQuery();
                if (query == null) {
                    return queryParameters;
                }
            }
            catch (IllegalArgumentException ex) {
                return queryParameters;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(query, "&");
        while (stringTokenizer.hasMoreTokens()) {
            String keyValue = stringTokenizer.nextToken().trim();
            if (keyValue.isEmpty()) continue;
            int equalPos = keyValue.indexOf("=");
            String key = URLDecoder.decode(keyValue.substring(0, equalPos != -1 ? equalPos : keyValue.length()), ENCODING);
            if (equalPos == -1 || equalPos == keyValue.length() - 1) {
                queryParameters.put(key.toLowerCase(), "");
                continue;
            }
            String value = URLDecoder.decode(keyValue.substring(equalPos + 1), ENCODING);
            queryParameters.put(key.toLowerCase(), value);
        }
        return queryParameters;
    }

    public static String getConcatenatedParameters(Map<String, String> parameters, String ... keys) {
        StringBuilder keyValues = new StringBuilder();
        for (String key : keys) {
            String value = parameters.get(key.toLowerCase().trim());
            if (value == null) continue;
            if (keyValues.length() != 0) {
                keyValues.append("&");
            }
            keyValues.append(key.toUpperCase());
            keyValues.append("=");
            keyValues.append(value);
        }
        return keyValues.toString();
    }

    public static URI relativize(URI base, URI target) {
        if (!base.getScheme().equals(target.getScheme())) {
            return target;
        }
        StringBuilder rel = new StringBuilder();
        String path = base.getPath();
        String separator = "/";
        StringTokenizer tokenizer = new StringTokenizer(target.getPath(), separator);
        String targetPart = "";
        if (tokenizer.hasMoreTokens()) {
            targetPart = tokenizer.nextToken();
        }
        if (path.startsWith(separator)) {
            path = path.substring(1);
        }
        StringTokenizer baseTokenizer = new StringTokenizer(path, separator, true);
        while (baseTokenizer.hasMoreTokens()) {
            String basePart = baseTokenizer.nextToken();
            if (!baseTokenizer.hasMoreTokens()) continue;
            baseTokenizer.nextToken();
            if (basePart.isEmpty()) continue;
            while (targetPart.isEmpty() && tokenizer.hasMoreTokens()) {
                targetPart = tokenizer.nextToken();
            }
            if (!basePart.equals(targetPart)) {
                rel.append("..");
                rel.append(separator);
                continue;
            }
            if (!tokenizer.hasMoreTokens()) continue;
            targetPart = tokenizer.nextToken();
        }
        rel.append(targetPart);
        while (tokenizer.hasMoreTokens()) {
            targetPart = tokenizer.nextToken();
            rel.append(separator);
            rel.append(targetPart);
        }
        try {
            return new URI(null, null, rel.toString(), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Illegal URI provided:\n" + base.toString() + "\n" + target.toString());
        }
    }

    public static File fileFromString(String fileName) {
        try {
            return new File(new URI(fileName).getPath());
        }
        catch (URISyntaxException ex) {
            return new File(fileName);
        }
    }
}

