/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import com.vividsolutions.jts.geom.Coordinate;

public final class CoordinateUtils {
    public static double[] zMinMax(Coordinate[] cs) {
        boolean validZFound = false;
        double[] result = new double[2];
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        for (int t = cs.length - 1; t >= 0; --t) {
            double z = cs[t].z;
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        result[0] = zmin;
        result[1] = zmax;
        return result;
    }

    public static double interpolate(Coordinate firstCoordinate, Coordinate lastCoordinate, Coordinate toBeInterpolated) {
        if (Double.isNaN(firstCoordinate.z)) {
            return Double.NaN;
        }
        if (Double.isNaN(lastCoordinate.z)) {
            return Double.NaN;
        }
        return firstCoordinate.z + (lastCoordinate.z - firstCoordinate.z) * firstCoordinate.distance(toBeInterpolated) / (firstCoordinate.distance(toBeInterpolated) + toBeInterpolated.distance(lastCoordinate));
    }

    public static boolean contains2D(Coordinate[] coords, Coordinate coord) {
        for (Coordinate coordinate : coords) {
            if (!coordinate.equals2D(coord)) continue;
            return true;
        }
        return false;
    }

    private CoordinateUtils() {
    }
}

