/*
 * Decompiled with CFR 0.152.
 */
package org.h2gis.utilities.jts_utils;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Triangle;

public class TriMarkers
extends Triangle {
    double m1;
    double m2;
    double m3;

    public TriMarkers() {
        super(new Coordinate(), new Coordinate(), new Coordinate());
        this.m1 = 0.0;
        this.m2 = 0.0;
        this.m3 = 0.0;
    }

    public String toString() {
        return "TriMarkers{p1=" + this.p0 + ", p2=" + this.p1 + ", p3=" + this.p2 + " m1=" + this.m1 + ", m2=" + this.m2 + ", m3=" + this.m3 + "}";
    }

    public TriMarkers(Coordinate p0, Coordinate p1, Coordinate p2, double m1, double m2, double m3) {
        super(p0, p1, p2);
        if (!CGAlgorithms.isCCW((Coordinate[])this.getRing())) {
            this.setCoordinates(p2, p1, p0);
            this.m1 = m3;
            this.m3 = m1;
        } else {
            this.m1 = m1;
            this.m3 = m3;
        }
        this.m2 = m2;
    }

    void setMarkers(double m1, double m2, double m3) {
        this.m1 = m1;
        this.m2 = m2;
        this.m3 = m3;
    }

    void setAll(Coordinate p0, Coordinate p1, Coordinate p2, double m1, double m2, double m3) {
        this.setCoordinates(p0, p1, p2);
        this.setMarkers(m1, m2, m3);
        if (!CGAlgorithms.isCCW((Coordinate[])this.getRing())) {
            this.setCoordinates(p2, p1, p0);
            this.m1 = m3;
            this.m3 = m1;
        }
    }

    double getMinMarker() {
        return this.getMinMarker(-1);
    }

    double getMinMarker(int exception) {
        double minval = Double.POSITIVE_INFINITY;
        if (exception != 0) {
            minval = Math.min(minval, this.m1);
        }
        if (exception != 1) {
            minval = Math.min(minval, this.m2);
        }
        if (exception != 2) {
            minval = Math.min(minval, this.m3);
        }
        return minval;
    }

    double getMaxMarker() {
        return this.getMaxMarker(-1);
    }

    double getMaxMarker(int exception) {
        double maxval = Double.NEGATIVE_INFINITY;
        if (exception != 0) {
            maxval = Math.max(maxval, this.m1);
        }
        if (exception != 1) {
            maxval = Math.max(maxval, this.m2);
        }
        if (exception != 2) {
            maxval = Math.max(maxval, this.m3);
        }
        return maxval;
    }

    void setCoordinates(Coordinate p0, Coordinate p1, Coordinate p2) {
        this.p0 = p0;
        this.p1 = p1;
        this.p2 = p2;
    }

    Coordinate[] getRing() {
        return new Coordinate[]{this.p0, this.p1, this.p2, this.p0};
    }

    Coordinate getVertice(int idvert) {
        if (idvert == 0) {
            return this.p0;
        }
        if (idvert == 1) {
            return this.p1;
        }
        return this.p2;
    }

    double getMarker(int idvert) {
        if (idvert == 0) {
            return this.m1;
        }
        if (idvert == 1) {
            return this.m2;
        }
        return this.m3;
    }
}

