/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.xml;

import com.ebmwebsourcing.easycommons.stream.EasyByteArrayOutputStream;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.Transformers;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLHelper {
    private static final String XML_STR_ENCODING = "UTF-8";

    public static final String toString(NodeList list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            Node cNode = null;
            for (int i = 0; i < list.getLength(); ++i) {
                cNode = list.item(i);
                if (cNode.getNodeType() == 3 || cNode.getNodeType() == 4) {
                    sb.append(cNode.getTextContent());
                    continue;
                }
                sb.append(XMLPrettyPrinter.prettyPrint(list.item(i)));
            }
        }
        return sb.toString();
    }

    public static final String createStringFromDOMDocument(Node document) throws TransformerException {
        return XMLHelper.createStringFromDOMNode(document, false);
    }

    public static final String createStringFromDOMNode(Node node) throws TransformerException {
        return XMLHelper.createStringFromDOMNode(node, true);
    }

    /*
     * Loose catch block
     */
    public static final String createStringFromDOMNode(Node node, boolean omitDeclaration) throws TransformerException {
        assert (node != null);
        node.normalize();
        Transformer transformer = Transformers.takeTransformer();
        try {
            try (EasyByteArrayOutputStream out = new EasyByteArrayOutputStream();){
                transformer.setOutputProperty("method", "xml");
                if (omitDeclaration) {
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                } else {
                    transformer.setOutputProperty("omit-xml-declaration", "no");
                }
                transformer.transform(new DOMSource(node), new StreamResult((OutputStream)out));
                String string = out.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
    }

    public static final void writeDocument(Document document, OutputStream outputStream) throws TransformerException {
        assert (document != null);
        assert (outputStream != null);
        Transformer transformer = Transformers.takeTransformer();
        try {
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        finally {
            Transformers.releaseTransformer(transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Document createDocumentFromString(String xml) throws SAXException, IOException {
        assert (xml != null);
        StringReader in = new StringReader(xml);
        InputSource inputSource = new InputSource(in);
        DocumentBuilder documentBuilder = DocumentBuilders.takeDocumentBuilder();
        try {
            Document document = documentBuilder.parse(inputSource);
            document.normalize();
            Document document2 = document;
            return document2;
        }
        finally {
            DocumentBuilders.releaseDocumentBuilder(documentBuilder);
        }
    }

    public static final Node findChild(Node parentNode, String namespaceURI, String nodeName, boolean recursive) {
        Node resultNode = null;
        if (parentNode != null && nodeName != null) {
            parentNode.normalize();
            NodeList nodeList = parentNode.getChildNodes();
            resultNode = XMLHelper.lookUpNodeInNodeList(nodeName, namespaceURI, nodeList);
            if (resultNode == null && recursive) {
                for (int i = 0; i < nodeList.getLength() && resultNode == null; ++i) {
                    resultNode = XMLHelper.findChild(nodeList.item(i), namespaceURI, nodeName, true);
                }
            }
        }
        return resultNode;
    }

    private static final Node lookUpNodeInNodeList(String nodeName, String namespaceURI, NodeList nodeList) {
        Node resultNode = null;
        for (int i = 0; i < nodeList.getLength() && resultNode == null; ++i) {
            Node tmpNode = nodeList.item(i);
            if (namespaceURI != null && tmpNode.getNamespaceURI() != null && tmpNode.getNamespaceURI().equals(namespaceURI) && nodeName.equals(tmpNode.getLocalName())) {
                resultNode = tmpNode;
                continue;
            }
            if (!nodeName.equals(tmpNode.getLocalName())) continue;
            resultNode = tmpNode;
        }
        return resultNode;
    }

    public static List<Element> getChildrenElementNS(Node parent, String namespaceURI) {
        assert (parent != null);
        assert (namespaceURI != null);
        ArrayList<Element> childrenElts = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !namespaceURI.equals(child.getNamespaceURI())) continue;
            childrenElts.add((Element)child);
        }
        return childrenElts;
    }

    public static List<Element> getChildrenElementNS(Node parent, String namespaceURI, String localName) {
        assert (parent != null);
        assert (namespaceURI != null);
        assert (localName != null);
        ArrayList<Element> nodeList = new ArrayList<Element>();
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !localName.equals(child.getLocalName()) || !namespaceURI.equals(child.getNamespaceURI())) continue;
            nodeList.add((Element)child);
        }
        return nodeList;
    }
}

