/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nexus;

public class MavenArtifact {
    private static final String CENTRAL_CONTENT_URL = "http://search.maven.org/remotecontent?filepath=";
    private String groupId;
    private String artifactId;
    private String version;
    private String artifactUrl;
    private String pomUrl;

    public MavenArtifact() {
    }

    public MavenArtifact(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public MavenArtifact(String groupId, String artifactId, String version, boolean jarAvailable, boolean pomAvailable) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        if (jarAvailable) {
            this.artifactUrl = CENTRAL_CONTENT_URL + groupId.replace('.', '/') + "/" + artifactId.replace('.', '/') + "/" + version + "/" + artifactId + "-" + version + ".jar";
        }
        if (pomAvailable) {
            this.pomUrl = CENTRAL_CONTENT_URL + groupId.replace('.', '/') + "/" + artifactId.replace('.', '/') + "/" + version + "/" + artifactId + "-" + version + ".pom";
        }
    }

    public MavenArtifact(String groupId, String artifactId, String version, String url) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifactUrl = url;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
    }

    public String getArtifactUrl() {
        return this.artifactUrl;
    }

    public String getPomUrl() {
        return this.pomUrl;
    }

    public void setPomUrl(String pomUrl) {
        this.pomUrl = pomUrl;
    }
}

