/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.pac4j.core.adapter.FrameworkAdapter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.util.security.SecurityEndpoint;
import org.pac4j.core.util.security.SecurityEndpointBuilder;
import org.pac4j.jee.config.AbstractConfigFilter;
import org.pac4j.jee.context.JEEFrameworkParameters;
import org.pac4j.jee.util.Pac4JHttpServletRequestWrapper;

public class SecurityFilter
extends AbstractConfigFilter
implements SecurityEndpoint {
    private String clients;
    private String authorizers;
    private String matchers;

    public SecurityFilter() {
    }

    public SecurityFilter(Config config) {
        this.setConfig(config);
    }

    public SecurityFilter(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    public SecurityFilter(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    public SecurityFilter(Config config, String clients, String authorizers, String matchers) {
        this(config, clients, authorizers);
        this.matchers = matchers;
    }

    public static SecurityFilter build(Object ... parameters) {
        SecurityFilter securityFilter = new SecurityFilter();
        SecurityEndpointBuilder.buildConfig((SecurityEndpoint)securityFilter, (Object[])parameters);
        return securityFilter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.clients = this.getStringParam(filterConfig, "clients", this.clients);
        this.authorizers = this.getStringParam(filterConfig, "authorizers", this.authorizers);
        this.matchers = this.getStringParam(filterConfig, "matchers", this.matchers);
    }

    protected final void internalFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        Config config = this.getSharedConfig();
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(config);
        config.getSecurityLogic().perform(config, (ctx, session, profiles) -> {
            filterChain.doFilter((ServletRequest)(profiles.isEmpty() ? request : new Pac4JHttpServletRequestWrapper(request, profiles)), (ServletResponse)response);
            return null;
        }, this.clients, this.authorizers, this.matchers, (FrameworkParameters)new JEEFrameworkParameters(request, response));
    }

    @Generated
    public String getClients() {
        return this.clients;
    }

    @Generated
    public String getAuthorizers() {
        return this.authorizers;
    }

    @Generated
    public String getMatchers() {
        return this.matchers;
    }

    @Generated
    public void setClients(String clients) {
        this.clients = clients;
    }

    @Generated
    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    @Generated
    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }
}

