/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.util;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.pac4j.core.adapter.FrameworkAdapter;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.jee.context.JEEFrameworkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@RequestScoped
public class Pac4jProducer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jProducer.class);

    @Produces
    WebContext getWebContext(Config config, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(config);
        LOGGER.trace("Producing a pac4j web context...");
        WebContext webContext = config.getWebContextFactory().newContext((FrameworkParameters)new JEEFrameworkParameters(httpServletRequest, httpServletResponse));
        LOGGER.trace("Returning a pac4j web context.");
        return webContext;
    }

    @Produces
    SessionStore getSessionStore(Config config, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(config);
        LOGGER.trace("Producing a pac4j session store...");
        SessionStore sessionStore = config.getSessionStoreFactory().newSessionStore((FrameworkParameters)new JEEFrameworkParameters(httpServletRequest, httpServletResponse));
        LOGGER.trace("Returning a pac4j session store.");
        return sessionStore;
    }

    @Produces
    ProfileManager getProfileManager(Config config, WebContext webContext, SessionStore sessionStore) {
        FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(config);
        LOGGER.trace("Producing a pac4j profile manager...");
        ProfileManager profileManager = (ProfileManager)config.getProfileManagerFactory().apply((Object)webContext, (Object)sessionStore);
        LOGGER.trace("Returning a pac4j profile manager.");
        return profileManager;
    }
}

