/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.authenticator.test;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.http.credentials.DigestCredentials;

public class SimpleTestDigestAuthenticator
implements Authenticator<TokenCredentials> {
    public void validate(TokenCredentials credentials, WebContext context) throws HttpAction, CredentialsException {
        if (credentials == null) {
            throw new CredentialsException("No credential");
        }
        if (!(credentials instanceof DigestCredentials)) {
            throw new CredentialsException("Unsupported credentials type " + credentials.getClass());
        }
        DigestCredentials digestCredentials = (DigestCredentials)credentials;
        String username = digestCredentials.getUsername();
        if (CommonHelper.isBlank((String)username)) {
            throw new CredentialsException("Username cannot be blank");
        }
        String token = credentials.getToken();
        if (CommonHelper.isBlank((String)token)) {
            throw new CredentialsException("Token cannot be blank");
        }
        CommonProfile profile = new CommonProfile();
        profile.setId((Object)username);
        credentials.setUserProfile(profile);
    }
}

