/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.http.credentials.extractor;

import java.util.Collection;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.util.CommonHelper;

public class CookieExtractor
implements CredentialsExtractor<TokenCredentials> {
    private final String cookieName;
    private final String clientName;

    public CookieExtractor(String cookieName, String clientName) {
        this.cookieName = cookieName;
        this.clientName = clientName;
    }

    public TokenCredentials extract(WebContext context) throws HttpAction {
        Collection col = context.getRequestCookies();
        for (Cookie c : col) {
            if (!c.getName().equals(this.cookieName)) continue;
            return new TokenCredentials(c.getValue(), this.clientName);
        }
        return null;
    }

    public String toString() {
        return CommonHelper.toString(this.getClass(), (Object[])new Object[]{"cookieName", this.cookieName, "clientName", this.clientName});
    }
}

