/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.undertow;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.handlers.AuthenticationCallHandler;
import io.undertow.security.handlers.AuthenticationConstraintHandler;
import io.undertow.security.handlers.AuthenticationMechanismsHandler;
import io.undertow.security.handlers.SecurityInitialHandler;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import java.util.Collections;
import java.util.List;
import org.pac4j.core.authorization.AuthorizationChecker;
import org.pac4j.core.authorization.DefaultAuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.ClientFinder;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DefaultClientFinder;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.undertow.UndertowWebContext;
import org.pac4j.undertow.security.Pac4jAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityMechanism
implements AuthenticationMechanism {
    private static final String NAME = "PAC4J_ACCOUNT";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ClientFinder clientFinder = new DefaultClientFinder();
    protected AuthorizationChecker authorizationChecker = new DefaultAuthorizationChecker();
    protected Config config;
    protected String clients;
    protected String authorizers;

    public static HttpHandler build(HttpHandler toWrap, Config config) {
        return SecurityMechanism.build(toWrap, new SecurityMechanism(config, null, null));
    }

    public static HttpHandler build(HttpHandler toWrap, Config config, String clients) {
        return SecurityMechanism.build(toWrap, new SecurityMechanism(config, clients, null));
    }

    public static HttpHandler build(HttpHandler toWrap, Config config, String clients, String authorizers) {
        return SecurityMechanism.build(toWrap, new SecurityMechanism(config, clients, authorizers));
    }

    private static HttpHandler build(HttpHandler toWrap, SecurityMechanism mechanism) {
        HttpHandler handler = toWrap;
        handler = new AuthenticationCallHandler(handler);
        handler = new AuthenticationConstraintHandler(handler);
        List<SecurityMechanism> mechanisms = Collections.singletonList(mechanism);
        handler = new AuthenticationMechanismsHandler(handler, mechanisms);
        handler = new SecurityInitialHandler(AuthenticationMode.PRO_ACTIVE, null, handler);
        return new BlockingHandler(handler);
    }

    private SecurityMechanism(Config config, String clients, String authorizers) {
        this.config = config;
        this.clients = clients;
        this.authorizers = authorizers;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowWebContext context = new UndertowWebContext(exchange);
        Clients configClients = this.config.getClients();
        CommonHelper.assertNotNull((String)"configClients", (Object)configClients);
        this.logger.debug("clients: {}", (Object)this.clients);
        List currentClients = this.clientFinder.find(configClients, (WebContext)context, this.clients);
        this.logger.debug("currentClients: {}", (Object)currentClients);
        boolean useSession = this.useSession(context, currentClients);
        this.logger.debug("useSession: {}", (Object)useSession);
        ProfileManager manager = new ProfileManager((WebContext)context);
        UserProfile profile = manager.get(useSession);
        this.logger.debug("profile: {}", (Object)profile);
        if (profile == null && currentClients != null && currentClients.size() > 0) {
            for (Client currentClient : currentClients) {
                Credentials credentials;
                if (!(currentClient instanceof DirectClient)) continue;
                this.logger.debug("Performing authentication for client: {}", (Object)currentClient);
                try {
                    credentials = currentClient.getCredentials((WebContext)context);
                    this.logger.debug("credentials: {}", (Object)credentials);
                }
                catch (RequiresHttpAction e) {
                    throw new TechnicalException("Unexpected HTTP action", (Throwable)e);
                }
                profile = currentClient.getUserProfile(credentials, (WebContext)context);
                this.logger.debug("profile: {}", (Object)profile);
                if (profile == null) continue;
                manager.save(useSession, profile);
                break;
            }
        }
        if (profile != null) {
            this.logger.debug("authorizers: {}", (Object)this.authorizers);
            securityContext.authenticationComplete((Account)new Pac4jAccount(profile), NAME, false);
            if (this.authorizationChecker.isAuthorized((WebContext)context, profile, this.authorizers, this.config.getAuthorizers())) {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        UndertowWebContext context = new UndertowWebContext(exchange);
        Pac4jAccount account = (Pac4jAccount)securityContext.getAuthenticatedAccount();
        Clients configClients = this.config.getClients();
        List currentClients = this.clientFinder.find(configClients, (WebContext)context, this.clients);
        if (account != null) {
            this.logger.debug("forbidden");
            this.forbidden(context, currentClients, account.getProfile());
        } else if (this.startAuthentication(context, currentClients)) {
            this.logger.debug("Starting authentication");
            this.saveRequestedUrl(context, currentClients);
            this.redirectToIdentityProvider(context, currentClients);
        } else {
            this.logger.debug("unauthorized");
            this.unauthorized(context, currentClients);
        }
        return new AuthenticationMechanism.ChallengeResult(true);
    }

    protected boolean useSession(WebContext context, List<Client> currentClients) {
        return currentClients == null || currentClients.size() == 0 || currentClients.get(0) instanceof IndirectClient;
    }

    protected void forbidden(WebContext context, List<Client> currentClients, UserProfile profile) {
        context.setResponseStatus(403);
    }

    protected boolean startAuthentication(WebContext context, List<Client> currentClients) {
        return currentClients != null && currentClients.size() > 0 && currentClients.get(0) instanceof IndirectClient;
    }

    protected void saveRequestedUrl(WebContext context, List<Client> currentClients) {
        String requestedUrl = context.getFullRequestURL();
        this.logger.debug("requestedUrl: {}", (Object)requestedUrl);
        context.setSessionAttribute("pac4jRequestedUrl", (Object)requestedUrl);
    }

    protected void redirectToIdentityProvider(WebContext context, List<Client> currentClients) {
        try {
            IndirectClient currentClient = (IndirectClient)currentClients.get(0);
            currentClient.redirect(context, true);
        }
        catch (RequiresHttpAction e) {
            this.logger.debug("extra HTTP action required: {}", (Object)e.getCode());
        }
    }

    protected void unauthorized(WebContext context, List<Client> currentClients) {
        context.setResponseStatus(401);
    }
}

