/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.util.HttpString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.pac4j.core.context.Cookie;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.JavaSerializationHelper;
import org.pac4j.undertow.session.UndertowSessionStore;

public class UndertowWebContext
implements WebContext {
    private static final JavaSerializationHelper JAVA_SERIALIZATION_HELPER = new JavaSerializationHelper();
    private final HttpServerExchange exchange;
    private final UndertowSessionStore sessionStore;

    public UndertowWebContext(HttpServerExchange exchange) {
        this.exchange = exchange;
        this.sessionStore = new UndertowSessionStore((SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY), (SessionConfig)exchange.getAttachment(SessionConfig.ATTACHMENT_KEY));
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    public String getRequestParameter(String name) {
        Deque param = (Deque)this.exchange.getQueryParameters().get(name);
        if (param != null) {
            return (String)param.peek();
        }
        FormData data = (FormData)this.exchange.getAttachment(FormDataParser.FORM_DATA);
        if (data != null && data.get(name) != null) {
            return ((FormData.FormValue)data.get(name).peek()).getValue();
        }
        return null;
    }

    public Map<String, String[]> getRequestParameters() {
        Map params = this.exchange.getQueryParameters();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Map.Entry entry : params.entrySet()) {
            map.put((String)entry.getKey(), ((Deque)entry.getValue()).toArray(new String[((Deque)entry.getValue()).size()]));
        }
        FormData data = (FormData)this.exchange.getAttachment(FormDataParser.FORM_DATA);
        if (data != null) {
            for (String key : data) {
                map.put(key, data.get(key).toArray(new String[data.get(key).size()]));
            }
        }
        return map;
    }

    public String getRequestHeader(String name) {
        return this.exchange.getRequestHeaders().get(name, 0);
    }

    public void setSessionAttribute(String name, Object value) {
        this.sessionStore.set(this, name, value);
    }

    public Object getSessionAttribute(String name) {
        return this.sessionStore.get(this, name);
    }

    public String getRequestMethod() {
        return this.exchange.getRequestMethod().toString();
    }

    public void writeResponseContent(String content) {
        this.exchange.getResponseSender().send(content);
    }

    public void setResponseStatus(int code) {
        this.exchange.setResponseCode(code);
    }

    public void setResponseHeader(String name, String value) {
        this.exchange.getResponseHeaders().put(HttpString.tryFromString((String)name), value);
    }

    public String getServerName() {
        return this.exchange.getHostName();
    }

    public int getServerPort() {
        return this.exchange.getHostPort();
    }

    public String getScheme() {
        return this.exchange.getProtocol().toString();
    }

    public String getFullRequestURL() {
        String full = this.exchange.getRequestURL();
        if (CommonHelper.isNotBlank((String)this.exchange.getQueryString())) {
            full = full + "?" + this.exchange.getQueryString();
        }
        return full;
    }

    public String getRemoteAddr() {
        return this.exchange.getSourceAddress().getAddress().getHostAddress();
    }

    public void addResponseCookie(Cookie cookie) {
        CookieImpl newCookie = new CookieImpl(cookie.getName(), cookie.getValue());
        newCookie.setComment(cookie.getComment());
        newCookie.setDomain(cookie.getDomain());
        newCookie.setPath(cookie.getPath());
        newCookie.setMaxAge(Integer.valueOf(cookie.getMaxAge()));
        newCookie.setSecure(cookie.isSecure());
        newCookie.setHttpOnly(cookie.isHttpOnly());
        this.exchange.setResponseCookie((io.undertow.server.handlers.Cookie)newCookie);
    }

    public void setRequestAttribute(String name, Object value) {
        String result = null;
        if (value != null) {
            result = JAVA_SERIALIZATION_HELPER.serializeToBase64((Serializable)value);
        }
        this.exchange.addPathParam(name, result);
    }

    public String getPath() {
        return this.exchange.getRequestPath();
    }

    public void setResponseContentType(String content) {
        this.exchange.getResponseHeaders().add(HttpString.tryFromString((String)"Content-Type"), content);
    }

    public Collection<Cookie> getRequestCookies() {
        Map cookiesMap = this.exchange.getRequestCookies();
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String key : cookiesMap.keySet()) {
            io.undertow.server.handlers.Cookie uCookie = (io.undertow.server.handlers.Cookie)cookiesMap.get(key);
            Cookie cookie = new Cookie(uCookie.getName(), uCookie.getValue());
            cookie.setComment(uCookie.getComment());
            cookie.setDomain(uCookie.getDomain());
            cookie.setPath(uCookie.getPath());
            cookie.setMaxAge(uCookie.getMaxAge().intValue());
            cookie.setSecure(uCookie.isSecure());
            cookie.setHttpOnly(uCookie.isHttpOnly());
            cookies.add(cookie);
        }
        return cookies;
    }

    public Object getSessionIdentifier() {
        return this.sessionStore.getOrCreateSessionId(this);
    }

    public Object getRequestAttribute(String name) {
        String serializedValue;
        Deque value = (Deque)this.exchange.getPathParameters().get(name);
        if (value != null && (serializedValue = (String)value.getFirst()) != null) {
            return JAVA_SERIALIZATION_HELPER.unserializeFromBase64(serializedValue);
        }
        return null;
    }

    public boolean isSecure() {
        return "HTTPS".equalsIgnoreCase(this.exchange.getRequestScheme().toString());
    }
}

