/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.regex.Pattern;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.undertow.UndertowWebContext;
import org.pac4j.undertow.utils.ExchangeHelper;

public class ApplicationLogoutHandler
implements HttpHandler {
    protected String defaultUrl = "/";
    protected String logoutUrlPattern = "/.*";
    private final Config config;

    public ApplicationLogoutHandler(Config config) {
        this.config = config;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        UndertowWebContext context = new UndertowWebContext(exchange);
        ProfileManager manager = new ProfileManager((WebContext)context);
        manager.logout();
        String url = context.getRequestParameter("url");
        if (url != null) {
            if (Pattern.matches(this.logoutUrlPattern, url)) {
                ExchangeHelper.redirect(exchange, url);
            } else {
                ExchangeHelper.redirect(exchange, this.defaultUrl);
            }
        } else {
            ExchangeHelper.ok(exchange, "");
        }
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }
}

