/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.form.EagerFormParsingHandler;
import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.undertow.UndertowWebContext;
import org.pac4j.undertow.utils.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler
implements HttpHandler {
    protected static final Logger logger = LoggerFactory.getLogger(CallbackHandler.class);
    private final Config config;
    protected String defaultUrl = "/";

    private CallbackHandler(Config config) {
        this.config = config;
    }

    public static HttpHandler build(Config config, String defaultUrl) {
        FormParserFactory factory = FormParserFactory.builder().addParser((FormParserFactory.ParserDefinition)new FormEncodedDataDefinition()).build();
        EagerFormParsingHandler formHandler = new EagerFormParsingHandler(factory);
        CallbackHandler callbackHandler = new CallbackHandler(config);
        if (CommonHelper.isNotBlank((String)defaultUrl)) {
            callbackHandler.setDefaultUrl(defaultUrl);
        }
        formHandler.setNext((HttpHandler)callbackHandler);
        return new BlockingHandler((HttpHandler)formHandler);
    }

    public static HttpHandler build(Config config) {
        return CallbackHandler.build(config, null);
    }

    public void handleRequest(HttpServerExchange exchange) {
        Credentials credentials;
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        UndertowWebContext context = new UndertowWebContext(exchange);
        Clients clients = this.config.getClients();
        CommonHelper.assertNotNull((String)"clients", (Object)clients);
        Client client = clients.findClient((WebContext)context);
        logger.debug("client: {}", (Object)client);
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertTrue((boolean)(client instanceof IndirectClient), (String)"only indirect clients are allowed on the callback url");
        try {
            credentials = client.getCredentials((WebContext)context);
        }
        catch (RequiresHttpAction e) {
            logger.debug("extra HTTP action required: {}", (Object)e.getCode());
            exchange.endExchange();
            return;
        }
        logger.debug("credentials: {}", (Object)credentials);
        UserProfile profile = client.getUserProfile(credentials, (WebContext)context);
        logger.debug("profile: {}", (Object)profile);
        this.saveUserProfile(context, profile);
        this.redirectToOriginallyRequestedUrl(context);
    }

    protected void saveUserProfile(WebContext context, UserProfile profile) {
        ProfileManager manager = new ProfileManager(context);
        if (profile != null) {
            manager.save(true, profile);
        }
    }

    protected void redirectToOriginallyRequestedUrl(WebContext context) {
        UndertowWebContext webContext = (UndertowWebContext)context;
        HttpServerExchange exchange = webContext.getExchange();
        String requestedUrl = (String)context.getSessionAttribute("pac4jRequestedUrl");
        logger.debug("requestedUrl: {}", (Object)requestedUrl);
        if (CommonHelper.isNotBlank((String)requestedUrl)) {
            context.setSessionAttribute("pac4jRequestedUrl", null);
            ExchangeHelper.redirect(exchange, requestedUrl);
        } else {
            ExchangeHelper.redirect(exchange, this.defaultUrl);
        }
    }

    protected String getDefaultUrl() {
        return this.defaultUrl;
    }

    protected void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }
}

