/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.undertow.session;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.InMemorySessionManager;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionAttachmentHandler;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionCookieConfig;
import io.undertow.server.session.SessionManager;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.undertow.UndertowWebContext;

public class UndertowSessionStore
implements SessionStore {
    private final SessionManager sessionManager;
    private final SessionConfig sessionConfig;

    public UndertowSessionStore() {
        this.sessionManager = new InMemorySessionManager("SessionManager");
        this.sessionConfig = new SessionCookieConfig();
    }

    public UndertowSessionStore(SessionManager sessionManager, SessionConfig sessionConfig) {
        this.sessionManager = sessionManager;
        this.sessionConfig = sessionConfig;
    }

    private Session getSession(WebContext context) {
        UndertowWebContext webContext = (UndertowWebContext)context;
        HttpServerExchange exchange = webContext.getExchange();
        Session session = this.sessionManager.getSession(exchange, this.sessionConfig);
        if (session == null) {
            ((SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY)).createSession(exchange, (SessionConfig)exchange.getAttachment(SessionConfig.ATTACHMENT_KEY));
            session = this.sessionManager.getSession(exchange, this.sessionConfig);
        }
        return session;
    }

    public String getOrCreateSessionId(WebContext context) {
        return this.getSession(context).getId();
    }

    public Object get(WebContext context, String key) {
        return this.getSession(context).getAttribute(key);
    }

    public void set(WebContext context, String key, Object value) {
        Session session = this.getSession(context);
        if (value == null) {
            session.removeAttribute(key);
        } else {
            session.setAttribute(key, value);
        }
    }

    public HttpHandler addSessionHandler(HttpHandler toWrap) {
        return new SessionAttachmentHandler(toWrap, this.sessionManager, this.sessionConfig);
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }
}

