/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Objects;

public class JClassUtils {
    public static <T> boolean isInstanceOf(JClass _class, Class<? extends T> _interface) {
        Objects.requireNonNull(_class);
        Objects.requireNonNull(_interface);
        String className = _class.fullName();
        try {
            if (_interface.isAssignableFrom(Class.forName(className))) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JClass superClass = _class._extends();
        if (superClass != null && JClassUtils.isInstanceOf(superClass, _interface)) {
            return true;
        }
        Iterator implementsIterator = _class._implements();
        while (implementsIterator.hasNext()) {
            JClass superInterface = (JClass)implementsIterator.next();
            if (!JClassUtils.isInstanceOf(superInterface, _interface)) continue;
            return true;
        }
        return false;
    }

    public static boolean classHasMethod(JDefinedClass theClass, String methodName, String[] parmTypeNames) {
        boolean baseClassHasMethod = false;
        block0: for (JMethod method : theClass.methods()) {
            if (!methodName.equals(method.name()) || method.params().size() != parmTypeNames.length) continue;
            for (int index = 0; index < parmTypeNames.length; ++index) {
                JType paramType = ((JVar)method.params().get(index)).type();
                if (!paramType.binaryName().equals(parmTypeNames[index])) continue;
                baseClassHasMethod = true;
                continue block0;
            }
        }
        return baseClassHasMethod;
    }

    public static boolean classHasMethod(Class<?> theClass, String methodName, String[] parmTypeNames) {
        boolean baseClassHasMethod = false;
        block0: for (Method method : theClass.getMethods()) {
            if (!methodName.equals(method.getName()) || method.getParameterCount() != parmTypeNames.length) continue;
            for (int index = 0; index < parmTypeNames.length; ++index) {
                Type paramType = method.getParameters()[index].getParameterizedType();
                if (!paramType.getTypeName().equals(parmTypeNames[index])) continue;
                baseClassHasMethod = true;
                continue block0;
            }
        }
        return baseClassHasMethod;
    }
}

