/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.idm.resolver;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import org.picketlink.common.reflection.Types;
import org.picketlink.config.idm.XMLConfigurationProvider;
import org.picketlink.config.idm.resolver.PropertyResolver;
import org.picketlink.idm.config.SecurityConfigurationException;

public abstract class BasicPropertyResolver<V>
implements PropertyResolver<V> {
    @Override
    public V resolveProperty(Object propertyValueFromConfiguration, Class<V> propertyClass) {
        if (propertyValueFromConfiguration instanceof String) {
            String stringValue = (String)propertyValueFromConfiguration;
            if ("null".equals(stringValue)) {
                return null;
            }
            return this.resolvePropertyFromString(stringValue, propertyClass);
        }
        throw new SecurityConfigurationException("Unknown type of propertyValue: " + propertyValueFromConfiguration);
    }

    protected abstract V resolvePropertyFromString(String var1, Class<V> var2);

    public static class PropertyEditorDelegateResolver<V>
    extends BasicPropertyResolver<V> {
        @Override
        protected V resolvePropertyFromString(String propertyValue, Class<V> propertyClass) {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(propertyClass);
            propertyEditor.setAsText(propertyValue);
            propertyClass = Types.boxedClass(propertyClass);
            return (V)propertyClass.cast(propertyEditor.getValue());
        }
    }

    public static class ClassResolver
    extends BasicPropertyResolver<Class> {
        @Override
        protected Class resolvePropertyFromString(String propertyValue, Class<Class> propertyClass) {
            return XMLConfigurationProvider.safeLoad(propertyValue);
        }
    }

    public static class StringResolver
    extends BasicPropertyResolver<String> {
        @Override
        protected String resolvePropertyFromString(String propertyValue, Class<String> propertyClass) {
            return propertyValue;
        }
    }
}

