/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.permission.spi;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.permission.spi.PermissionVoter;

public class PermissionResolver {
    private final List<PermissionVoter> voters;

    public PermissionResolver(List<PermissionVoter> voters) {
        this.voters = voters;
    }

    public boolean resolvePermission(IdentityType recipient, Object resource, String operation) {
        boolean permit = false;
        for (PermissionVoter voter : this.voters) {
            PermissionVoter.VotingResult result = voter.hasPermission(recipient, resource, operation);
            if (PermissionVoter.VotingResult.ALLOW.equals((Object)result)) {
                permit = true;
                continue;
            }
            if (!PermissionVoter.VotingResult.DENY.equals((Object)result)) continue;
            return false;
        }
        return permit;
    }

    public boolean resolvePermission(IdentityType recipient, Class<?> resourceClass, Serializable identifier, String operation) {
        boolean permit = false;
        for (PermissionVoter voter : this.voters) {
            PermissionVoter.VotingResult result = voter.hasPermission(recipient, resourceClass, identifier, operation);
            if (PermissionVoter.VotingResult.ALLOW.equals((Object)result)) {
                permit = true;
                continue;
            }
            if (!PermissionVoter.VotingResult.DENY.equals((Object)result)) continue;
            return false;
        }
        return permit;
    }
}

