/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal.mappers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jpa.annotations.OwnerReference;
import org.picketlink.idm.jpa.annotations.entity.IdentityManaged;

public class EntityMapping {
    private final Map<Property, Property> properties;
    private final Class<?> supportedType;
    private Property typeProperty;
    private boolean persist = true;

    public EntityMapping(Class<?> managedType, boolean persist) {
        this(managedType);
        this.persist = persist;
    }

    public EntityMapping(Class<?> managedType) {
        this.supportedType = managedType;
        this.properties = new HashMap<Property, Property>();
    }

    public void addProperty(Property property, Property mappedProperty) {
        if (mappedProperty != null) {
            this.properties.put(property, mappedProperty);
        }
    }

    public void addTypeProperty(Property property) {
        this.addProperty(new PropertyMapping(){

            public Object getValue(Object instance) {
                return instance.getClass().getName();
            }

            public void setValue(Object instance, Object value) {
            }
        }, property);
        this.typeProperty = property;
    }

    public boolean isPersist() {
        return this.persist;
    }

    public Map<Property, Property> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Property getTypeProperty() {
        return this.typeProperty;
    }

    public Class<?> getOwnerType() {
        for (Property property : this.getProperties().values()) {
            if (!property.getAnnotatedElement().isAnnotationPresent(OwnerReference.class)) continue;
            return property.getJavaClass();
        }
        return null;
    }

    public void addOwnerProperty(Class<?> entityType) {
        final Property ownerProperty = PropertyQueries.createQuery(entityType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(OwnerReference.class)).getFirstResult();
        if (ownerProperty == null) {
            throw IDMMessages.MESSAGES.configJpaStoreRequiredMappingAnnotation(entityType, OwnerReference.class);
        }
        this.addProperty(new PropertyMapping(){

            public Object getValue(Object instance) {
                IdentityManaged identityManaged = ownerProperty.getJavaClass().getAnnotation(IdentityManaged.class);
                if (identityManaged != null) {
                    for (Class ownerType : identityManaged.value()) {
                        Property ownerProperty2 = PropertyQueries.createQuery(instance.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(ownerType, TypedPropertyCriteria.MatchOption.ALL)).getFirstResult();
                        if (ownerProperty2 == null || ownerProperty2.getJavaClass().equals(instance.getClass())) continue;
                        return ownerProperty2.getValue(instance);
                    }
                }
                return instance;
            }

            public void setValue(Object instance, Object value) {
                IdentityManaged identityManaged = ownerProperty.getJavaClass().getAnnotation(IdentityManaged.class);
                for (Class ownerType : identityManaged.value()) {
                    Property ownerProperty2 = PropertyQueries.createQuery(instance.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(ownerType, TypedPropertyCriteria.MatchOption.ALL)).getFirstResult();
                    if (ownerProperty2 == null || !ownerType.isInstance(value)) continue;
                    ownerProperty2.setValue(instance, value);
                    return;
                }
            }
        }, ownerProperty);
    }

    public void addProperty(final String propertyName, Property mappedProperty) {
        this.addProperty(new PropertyMapping(){

            @Override
            public String getName() {
                return propertyName;
            }

            public Object getValue(Object instance) {
                Property property;
                if (instance != null && (property = PropertyQueries.createQuery(instance.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName})).getFirstResult()) != null) {
                    return property.getValue(instance);
                }
                return null;
            }

            public void setValue(Object instance, Object value) {
                Property property;
                if (instance != null && (property = PropertyQueries.createQuery(instance.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName})).getFirstResult()) != null) {
                    property.setValue(instance, value);
                }
            }
        }, mappedProperty);
    }

    public boolean supports(Class<?> type) {
        return this.supportedType.isAssignableFrom(type);
    }

    public Class<?> getSupportedType() {
        return this.supportedType;
    }

    public void addMappedProperty(Property mappedProperty) {
        this.addProperty(new PropertyMapping(){

            public Object getValue(Object instance) {
                return null;
            }

            public void setValue(Object instance, Object value) {
            }
        }, mappedProperty);
    }

    public void addNotNullMappedProperty(final Property mappedProperty) {
        this.addProperty(new PropertyMapping(){

            public Object getValue(Object instance) {
                return null;
            }

            public void setValue(Object instance, Object value) {
            }
        }, (Property)new PropertyMapping(){

            @Override
            public String getName() {
                return mappedProperty.getName();
            }

            @Override
            public AnnotatedElement getAnnotatedElement() {
                return mappedProperty.getAnnotatedElement();
            }

            @Override
            public Class getJavaClass() {
                return mappedProperty.getJavaClass();
            }

            public Object getValue(Object instance) {
                return mappedProperty.getValue(instance);
            }

            public void setValue(Object instance, Object value) {
                if (value != null) {
                    mappedProperty.setValue(instance, value);
                }
            }
        });
    }

    private abstract class PropertyMapping<V>
    implements Property<V> {
        private PropertyMapping() {
        }

        public String getName() {
            return "";
        }

        public Type getBaseType() {
            return this.getClass();
        }

        public Class getJavaClass() {
            return this.getClass();
        }

        public AnnotatedElement getAnnotatedElement() {
            return this.getClass();
        }

        public Member getMember() {
            return null;
        }

        public Class<?> getDeclaringClass() {
            return null;
        }

        public boolean isReadOnly() {
            return false;
        }

        public void setAccessible() {
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
            return false;
        }
    }
}

