/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.RecordComponentNode;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.engine.Location;

public class ClassTree {
    private final ClassNode rawNode;
    private List<MethodTree> lazyMethods;

    public ClassTree(ClassNode rawNode) {
        this.rawNode = rawNode;
    }

    public static ClassTree fromBytes(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept(classNode, 8);
        return new ClassTree(classNode);
    }

    public List<MethodTree> methods() {
        if (this.lazyMethods != null) {
            return this.lazyMethods;
        }
        this.lazyMethods = FCollection.map(this.rawNode.methods, ClassTree.toTree(this.name()));
        return this.lazyMethods;
    }

    public Optional<MethodTree> method(Location loc) {
        return this.methods().stream().filter(MethodMatchers.forLocation(loc)).findFirst();
    }

    public List<AnnotationNode> annotations() {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (this.rawNode.invisibleAnnotations != null) {
            annotations.addAll(this.rawNode.invisibleAnnotations);
        }
        if (this.rawNode.visibleAnnotations != null) {
            annotations.addAll(this.rawNode.visibleAnnotations);
        }
        return annotations;
    }

    public List<RecordComponentNode> recordComponents() {
        if (this.rawNode.recordComponents == null) {
            return Collections.emptyList();
        }
        return this.rawNode.recordComponents;
    }

    private static Function<MethodNode, MethodTree> toTree(ClassName name) {
        return a -> new MethodTree(name, (MethodNode)a);
    }

    public ClassName name() {
        return ClassName.fromString((String)this.rawNode.name);
    }

    public ClassNode rawNode() {
        return this.rawNode;
    }

    public Set<Integer> codeLineNumbers() {
        return this.realMethods().flatMap(m -> m.instructions().stream().filter(n -> n instanceof LineNumberNode).map(n -> ((LineNumberNode)n).line)).collect(Collectors.toSet());
    }

    public int numberOfCodeLines() {
        return this.codeLineNumbers().size();
    }

    public Stream<MethodTree> realMethods() {
        return this.methods().stream().filter(m -> !m.isBridge() && !m.isSynthetic() || m.isGeneratedLambdaMethod());
    }

    public boolean isAbstract() {
        return (this.rawNode.access & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.rawNode.access & 0x200) != 0;
    }

    public boolean isSynthetic() {
        return (this.rawNode.access & 0x1000) != 0;
    }

    public ClassTree rename(ClassName name) {
        this.rawNode.name = name.asInternalName();
        return this;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.rawNode.accept(new TraceClassVisitor(null, new Textifier(), new PrintWriter(writer)));
        return writer.toString();
    }
}

