/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.pitest.classinfo.AddlerHash;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassInfoBuilder;
import org.pitest.classinfo.ClassInfoSource;
import org.pitest.classinfo.ClassInfoVisitor;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.ClassPointer;
import org.pitest.classinfo.DefaultClassPointer;
import org.pitest.classinfo.DeferredClassPointer;
import org.pitest.classinfo.HashFunction;

public class Repository
implements ClassInfoSource {
    private final HashFunction hashFunction;
    private final Map<ClassName, ClassInfo> knownClasses = new HashMap<ClassName, ClassInfo>();
    private final Set<ClassName> unknownClasses = new HashSet<ClassName>();
    private final ClassByteArraySource source;

    public Repository(ClassByteArraySource source) {
        this(source, new AddlerHash());
    }

    Repository(ClassByteArraySource source, HashFunction hashFunction) {
        this.source = source;
        this.hashFunction = hashFunction;
    }

    public boolean hasClass(ClassName name) {
        return this.knownClasses.containsKey(name) || this.querySource(name).isPresent();
    }

    public Optional<ClassInfo> fetchClass(Class<?> clazz) {
        return this.fetchClass(clazz.getName());
    }

    private Optional<ClassInfo> fetchClass(String name) {
        return this.fetchClass(ClassName.fromString((String)name));
    }

    @Override
    public Optional<ClassInfo> fetchClass(ClassName name) {
        ClassInfo info = this.knownClasses.get(name);
        if (info != null) {
            return Optional.ofNullable(info);
        }
        Optional<ClassInfo> maybeInfo = this.nameToClassInfo(name);
        if (maybeInfo.isPresent()) {
            this.knownClasses.put(name, maybeInfo.get());
        }
        return maybeInfo;
    }

    private Optional<ClassInfo> nameToClassInfo(ClassName name) {
        Optional<byte[]> bytes = this.querySource(name);
        if (bytes.isPresent()) {
            ClassInfoBuilder classData = ClassInfoVisitor.getClassInfo(name, bytes.get(), this.hashFunction.hash(bytes.get()));
            return this.constructClassInfo(classData);
        }
        return Optional.empty();
    }

    public Optional<byte[]> querySource(ClassName name) {
        if (this.unknownClasses.contains(name)) {
            return Optional.empty();
        }
        Optional option = this.source.getBytes(name.asJavaName());
        if (option.isPresent()) {
            return option;
        }
        this.unknownClasses.add(name);
        return option;
    }

    private Optional<ClassInfo> constructClassInfo(ClassInfoBuilder classData) {
        return Optional.ofNullable(new ClassInfo(this.resolveClass(classData.superClass), this.resolveClass(classData.outerClass), classData));
    }

    private ClassPointer resolveClass(String clazz) {
        if (clazz == null) {
            return new DefaultClassPointer(null);
        }
        ClassInfo alreadyResolved = this.knownClasses.get(ClassName.fromString((String)clazz));
        if (alreadyResolved != null) {
            return new DefaultClassPointer(alreadyResolved);
        }
        return new DeferredClassPointer(this, ClassName.fromString((String)clazz));
    }
}

