/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.staticinitializers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.staticinitializers.Call;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

class StaticInitializerInterceptor
implements MutationInterceptor {
    static final Slot<AbstractInsnNode> START = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> DELAYED_EXECUTION = QueryStart.any(AbstractInsnNode.class).then(StaticInitializerInterceptor.returnsDeferredExecutionCode().or(StaticInitializerInterceptor.dynamicallyReturnsDeferredExecutionCode()).and(StaticInitializerInterceptor.store(START.write()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(StaticInitializerInterceptor.enumConstructorCallAndStore().or(QueryStart.match(StaticInitializerInterceptor.delayedExecutionField()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));
    private Predicate<MutationDetails> isStaticInitCode;

    StaticInitializerInterceptor() {
    }

    private static Match<AbstractInsnNode> delayedExecutionField() {
        return OpcodeMatchers.PUTSTATIC.and(StaticInitializerInterceptor.isAUtilFunctionField());
    }

    private static Match<AbstractInsnNode> isAUtilFunctionField() {
        return (c, n) -> {
            FieldInsnNode fieldNode = (FieldInsnNode)n;
            return Result.result(fieldNode.desc.startsWith("Ljava/util/function/"), c);
        };
    }

    private static Match<AbstractInsnNode> dynamicallyReturnsDeferredExecutionCode() {
        return (c, n) -> Result.result(n.getOpcode() == 186 && StaticInitializerInterceptor.returnDelayedExecutionType(((InvokeDynamicInsnNode)n).desc), c);
    }

    private static Match<AbstractInsnNode> returnsDeferredExecutionCode() {
        return (c, n) -> Result.result(n.getOpcode() == 184 && StaticInitializerInterceptor.returnDelayedExecutionType(((MethodInsnNode)n).desc), c);
    }

    private static boolean returnDelayedExecutionType(String desc) {
        int endOfParams = desc.indexOf(41);
        return endOfParams <= 0 || desc.substring(endOfParams + 1).startsWith("Ljava/util/function/");
    }

    private static SequenceQuery<AbstractInsnNode> enumConstructorCallAndStore() {
        return QueryStart.match(InstructionMatchers.methodCallNamed("<init>")).then(OpcodeMatchers.PUTSTATIC);
    }

    @Override
    public void begin(ClassTree clazz) {
        this.analyseClass(clazz);
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isStaticInitCode != null) {
            return mutations.stream().filter(this.isStaticInitCode.negate()).collect(Collectors.toList());
        }
        return mutations;
    }

    @Override
    public void end() {
        this.isStaticInitCode = null;
    }

    private void analyseClass(ClassTree tree) {
        Optional<MethodTree> clinit = tree.methods().stream().filter(this.nameEquals("<clinit>")).findFirst();
        if (clinit.isPresent()) {
            Set privateMethods = tree.methods().stream().filter(MethodTree::isPrivate).map(MethodTree::asLocation).collect(Collectors.toSet());
            Set<Call> storedToSupplier = this.findCallsStoredToDelayedExecutionCode(tree);
            Map<Location, List<Call>> callTree = tree.methods().stream().filter(m -> m.isPrivate() || m.rawNode().name.equals("<clinit>")).flatMap(m -> this.allCallsFor(tree, (MethodTree)m).stream().map(c -> new Call(m.asLocation(), (Location)c))).filter(c -> privateMethods.contains(c.to())).filter(c -> !storedToSupplier.contains(c)).collect(Collectors.groupingBy(Call::from));
            HashSet<Location> calledOnlyFromStaticInitializer = new HashSet<Location>();
            this.visit(callTree, calledOnlyFromStaticInitializer, clinit.get().asLocation());
            this.isStaticInitCode = m -> calledOnlyFromStaticInitializer.contains(m.getId().getLocation());
        }
    }

    private Set<Call> findCallsStoredToDelayedExecutionCode(ClassTree tree) {
        return new HashSet<Call>(this.privateAndClinitCallsToDelayedExecutionCode(tree));
    }

    private Set<Call> privateAndClinitCallsToDelayedExecutionCode(ClassTree tree) {
        return tree.methods().stream().filter(m -> m.isPrivate() || m.rawNode().name.equals("<clinit>")).flatMap(m -> this.delayedExecutionCall((MethodTree)m).stream().map(c -> new Call(m.asLocation(), (Location)c))).collect(Collectors.toSet());
    }

    private List<Location> delayedExecutionCall(MethodTree method) {
        Context context = Context.start();
        return DELAYED_EXECUTION.contextMatches(method.instructions(), context).stream().map(c -> c.retrieve(START.read()).get()).flatMap(this::nodeToLocation).collect(Collectors.toList());
    }

    private List<Location> allCallsFor(ClassTree tree, MethodTree m) {
        return Stream.concat(this.callsFor(tree, m), this.invokeDynamicCallsFor(tree, m)).collect(Collectors.toList());
    }

    private Stream<Location> callsFor(ClassTree tree, MethodTree m) {
        return m.instructions().stream().flatMap(this.is(MethodInsnNode.class)).filter(this.calls(tree.name())).map(this::asLocation);
    }

    private Stream<Location> invokeDynamicCallsFor(ClassTree tree, MethodTree m) {
        return m.instructions().stream().flatMap(this.is(InvokeDynamicInsnNode.class)).filter(this.callsDynamically(tree.name())).flatMap(this::asLocation);
    }

    private void visit(Map<Location, List<Call>> callTree, Set<Location> visited, Location l) {
        if (visited.contains(l)) {
            return;
        }
        visited.add(l);
        for (Call each : callTree.getOrDefault(l, Collections.emptyList())) {
            this.visit(callTree, visited, each.to());
        }
    }

    private Stream<Location> nodeToLocation(AbstractInsnNode n) {
        if (n instanceof MethodInsnNode) {
            return Stream.of(this.asLocation((MethodInsnNode)n));
        }
        if (n instanceof InvokeDynamicInsnNode) {
            return this.asLocation((InvokeDynamicInsnNode)n);
        }
        return Stream.empty();
    }

    private Location asLocation(MethodInsnNode call) {
        return Location.location((ClassName)ClassName.fromString((String)call.owner), (String)call.name, (String)call.desc);
    }

    private Predicate<MethodInsnNode> calls(ClassName self) {
        return a -> a.owner.equals(self.asInternalName());
    }

    private Predicate<InvokeDynamicInsnNode> callsDynamically(ClassName self) {
        return a -> this.asLocation((InvokeDynamicInsnNode)a).anyMatch(l -> l.getClassName().equals((Object)self));
    }

    private Stream<Location> asLocation(InvokeDynamicInsnNode call) {
        return Arrays.stream(call.bsmArgs).flatMap(this.is(Handle.class)).flatMap(this::handleToLocation);
    }

    private Stream<Location> handleToLocation(Handle handle) {
        ClassName c = ClassName.fromString((String)handle.getOwner());
        return Stream.of(Location.location((ClassName)c, (String)handle.getName(), (String)handle.getDesc()));
    }

    private <T> Function<Object, Stream<T>> is(Class<T> clazz) {
        return a -> {
            if (a.getClass().isAssignableFrom(clazz)) {
                return Stream.of(a);
            }
            return Stream.empty();
        };
    }

    private Predicate<MethodTree> nameEquals(String name) {
        return a -> a.rawNode().name.equals(name);
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }
}

