/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.bytecode.analysis.OpcodeMatchers;
import org.pitest.mutationtest.build.intercept.MutatorSpecificInterceptor;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.Result;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotWrite;

class DivisionByMinusOneFilter
extends MutatorSpecificInterceptor {
    static final Slot<AbstractInsnNode> AVOID = Slot.create(AbstractInsnNode.class);
    static final SequenceMatcher<AbstractInsnNode> DIVISION_BY_1 = QueryStart.any(AbstractInsnNode.class).then(OpcodeMatchers.ICONST_M1.or(DivisionByMinusOneFilter.loads(-1L)).or(DivisionByMinusOneFilter.loads(Float.valueOf(-1.0f))).or(DivisionByMinusOneFilter.loads(-1.0))).then(OpcodeMatchers.IMUL.or(OpcodeMatchers.LMUL.or(OpcodeMatchers.FMUL).or(OpcodeMatchers.DMUL)).and(DivisionByMinusOneFilter.store(AVOID.write()))).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));

    DivisionByMinusOneFilter(MethodMutatorFactory ... mutators) {
        super(Arrays.asList(mutators));
    }

    private static Match<AbstractInsnNode> loads(Object l) {
        return (c, n) -> Result.result(n instanceof LdcInsnNode && ((LdcInsnNode)n).cst.equals(l), c);
    }

    private static Match<AbstractInsnNode> store(SlotWrite<AbstractInsnNode> slot) {
        return (c, n) -> Result.result(true, c.store(slot, n));
    }

    @Override
    protected List<Region> computeRegions(MethodTree method) {
        Context context = Context.start();
        return DIVISION_BY_1.contextMatches(method.instructions(), context).stream().map(c -> new Region(c.retrieve(AVOID.read()).get(), c.retrieve(AVOID.read()).get())).collect(Collectors.toList());
    }
}

