/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.process;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class ArgLineParser {
    private static final String ESCAPE_CHAR = "\\";
    private static final String SINGLE_QUOTE = "'";
    public static final String DOUBLE_QUOTE = "\"";

    public static List<String> split(String in) {
        return ArgLineParser.process(ArgLineParser.stripWhiteSpace(in));
    }

    private static List<String> process(String in) {
        if (in.isEmpty()) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(in, "\"' \\", true);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayDeque<State> state = new ArrayDeque<State>();
        state.push(State.START);
        StringBuilder current = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch ((State)((Object)state.peek())) {
                case START: {
                    if (token.equals(SINGLE_QUOTE)) {
                        state.push(State.IN_QUOTE);
                        break;
                    }
                    if (token.equals(DOUBLE_QUOTE)) {
                        state.push(State.IN_DOUBLE_QUOTE);
                        break;
                    }
                    if (token.equals(" ")) {
                        if (current.length() == 0) break;
                        tokens.add(current.toString());
                        current = new StringBuilder();
                        break;
                    }
                    current.append(token);
                    if (!token.equals(ESCAPE_CHAR)) break;
                    state.push(State.IN_ESCAPE);
                    break;
                }
                case IN_QUOTE: {
                    if (token.equals(SINGLE_QUOTE)) {
                        state.pop();
                        break;
                    }
                    current.append(token);
                    if (!token.equals(ESCAPE_CHAR)) break;
                    state.push(State.IN_ESCAPE);
                    break;
                }
                case IN_DOUBLE_QUOTE: {
                    if (token.equals(DOUBLE_QUOTE)) {
                        state.pop();
                        break;
                    }
                    current.append(token);
                    if (!token.equals(ESCAPE_CHAR)) break;
                    state.push(State.IN_ESCAPE);
                    break;
                }
                case IN_ESCAPE: {
                    current.append(token);
                    if (token.equals(ESCAPE_CHAR)) break;
                    state.pop();
                }
            }
        }
        if (current.length() != 0) {
            tokens.add(current.toString());
        }
        if (state.size() != 1) {
            throw new RuntimeException("Unclosed quote in " + in);
        }
        return tokens;
    }

    private static String stripWhiteSpace(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("\\s", " ").trim();
    }

    static enum State {
        START,
        IN_ESCAPE,
        IN_QUOTE,
        IN_DOUBLE_QUOTE;

    }
}

