/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.annotations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class ExcludedAnnotationInterceptor
implements MutationInterceptor {
    private final List<String> configuredAnnotations;
    private boolean skipClass;
    private Predicate<MutationDetails> annotatedMethodMatcher;

    ExcludedAnnotationInterceptor(List<String> configuredAnnotations) {
        this.configuredAnnotations = configuredAnnotations;
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.skipClass = clazz.annotations().stream().anyMatch(this.avoidedAnnotation());
        if (!this.skipClass) {
            List avoidedMethods = clazz.methods().stream().filter(this.hasAvoidedAnnotation()).collect(Collectors.toList());
            Set<Location> avoidedMethodSignatures = avoidedMethods.stream().map(method -> new Location(clazz.name(), method.rawNode().name, method.rawNode().desc)).collect(Collectors.toSet());
            HashSet<Location> processedMethods = new HashSet<Location>(avoidedMethodSignatures);
            for (MethodTree avoidedMethod : avoidedMethods) {
                this.collectLambdaMethods(avoidedMethod, clazz, avoidedMethodSignatures, processedMethods);
            }
            this.annotatedMethodMatcher = mutation -> {
                Location mutationSignature = Location.location((ClassName)clazz.name(), (String)mutation.getMethod(), (String)mutation.getId().getLocation().getMethodDesc());
                return avoidedMethodSignatures.contains(mutationSignature);
            };
        }
    }

    private void collectLambdaMethods(MethodTree method, ClassTree clazz, Set<Location> avoidedMethodSignatures, Set<Location> processedMethods) {
        LinkedList<MethodTree> methodsToProcess = new LinkedList<MethodTree>();
        methodsToProcess.add(method);
        while (!methodsToProcess.isEmpty()) {
            MethodTree currentMethod = (MethodTree)methodsToProcess.poll();
            Set lambdas = currentMethod.instructions().stream().flatMap(n -> this.lambdaCallsToClass(clazz.name(), (AbstractInsnNode)n)).filter(l -> !avoidedMethodSignatures.contains(l) && !processedMethods.contains(l)).collect(Collectors.toSet());
            List recurse = lambdas.stream().map(clazz::method).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            methodsToProcess.addAll(recurse);
            avoidedMethodSignatures.addAll(lambdas);
            processedMethods.addAll(lambdas);
        }
    }

    private Stream<Location> lambdaCallsToClass(ClassName clazz, AbstractInsnNode insn) {
        if (!(insn instanceof InvokeDynamicInsnNode)) {
            return Stream.empty();
        }
        InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
        for (Object bsmArg : indy.bsmArgs) {
            Handle handle;
            if (!(bsmArg instanceof Handle) || !(handle = (Handle)bsmArg).getOwner().equals(clazz.asInternalName()) || !handle.getName().startsWith("lambda$")) continue;
            return Stream.of(Location.location((ClassName)clazz, (String)handle.getName(), (String)handle.getDesc()));
        }
        return Stream.empty();
    }

    private Predicate<MethodTree> hasAvoidedAnnotation() {
        return methodTree -> methodTree.annotations().stream().anyMatch(this.avoidedAnnotation());
    }

    private Predicate<AnnotationNode> avoidedAnnotation() {
        return a -> this.shouldAvoid(a.desc);
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.skipClass) {
            return Collections.emptyList();
        }
        return mutations.stream().filter(this.annotatedMethodMatcher.negate()).collect(Collectors.toList());
    }

    @Override
    public void end() {
    }

    boolean shouldAvoid(String desc) {
        String matchAgainst = desc.replace(";", "");
        for (String each : this.configuredAnnotations) {
            if (!matchAgainst.endsWith(each)) continue;
            return true;
        }
        return false;
    }
}

