/*
 * Decompiled with CFR 0.152.
 */
package reactor.net;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Environment;
import reactor.core.Observable;
import reactor.core.Reactor;
import reactor.core.composable.Composable;
import reactor.core.composable.Deferred;
import reactor.core.composable.Promise;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.Promises;
import reactor.core.support.NotifyConsumer;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.event.registry.Registration;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.event.support.EventConsumer;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.function.batch.BatchConsumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.NetChannel;
import reactor.queue.BlockingQueueFactory;
import reactor.util.Assert;

public abstract class AbstractNetChannel<IN, OUT>
implements NetChannel<IN, OUT> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Selector read = Selectors.$();
    private final Environment env;
    private final Reactor ioReactor;
    private final Reactor eventsReactor;
    private final Codec<Buffer, IN, OUT> codec;
    private final Function<Buffer, IN> decoder;
    private final Function<OUT, Buffer> encoder;
    private final Queue<Object> replyToKeys;

    protected AbstractNetChannel(@Nonnull Environment env, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Dispatcher ioDispatcher, @Nonnull Reactor eventsReactor) {
        Assert.notNull((Object)env, (String)"IO Dispatcher cannot be null");
        Assert.notNull((Object)env, (String)"Events Reactor cannot be null");
        this.env = env;
        this.ioReactor = new Reactor(ioDispatcher, null, eventsReactor.getDispatchErrorHandler(), eventsReactor.getUncaughtErrorHandler());
        this.eventsReactor = new Reactor(eventsReactor.getDispatcher(), null, eventsReactor.getDispatchErrorHandler(), eventsReactor.getUncaughtErrorHandler());
        this.eventsReactor.getConsumerRegistry().clear();
        for (Registration reg : eventsReactor.getConsumerRegistry()) {
            this.eventsReactor.getConsumerRegistry().register(reg.getSelector(), reg.getObject());
        }
        this.codec = codec;
        if (null != codec) {
            this.decoder = codec.decoder((Consumer)new NotifyConsumer(this.read.getObject(), (Observable)this.eventsReactor));
            this.encoder = codec.encoder();
        } else {
            this.decoder = null;
            this.encoder = null;
        }
        this.replyToKeys = BlockingQueueFactory.createQueue();
        this.consume(new Consumer<IN>(){

            public void accept(IN in) {
                try {
                    if (!AbstractNetChannel.this.replyToKeys.isEmpty()) {
                        AbstractNetChannel.this.eventsReactor.notify(AbstractNetChannel.this.replyToKeys.remove(), Event.wrap(in));
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        });
    }

    public Function<Buffer, IN> getDecoder() {
        return this.decoder;
    }

    public Function<OUT, Buffer> getEncoder() {
        return this.encoder;
    }

    @Override
    public Stream<IN> in() {
        final Deferred d = new Deferred((Composable)new Stream((Observable)this.eventsReactor, -1, null, this.env));
        this.consume(new Consumer<IN>(){

            public void accept(IN in) {
                d.accept(in);
            }
        });
        return (Stream)d.compose();
    }

    @Override
    public BatchConsumer<OUT> out() {
        return new WriteConsumer(null);
    }

    @Override
    public <T extends Throwable> NetChannel<IN, OUT> when(Class<T> errorType, Consumer<T> errorConsumer) {
        this.eventsReactor.on(Selectors.T(errorType), (Consumer)new EventConsumer(errorConsumer));
        return this;
    }

    @Override
    public NetChannel<IN, OUT> consume(final Consumer<IN> consumer) {
        this.eventsReactor.on(this.read, new Consumer<Event<IN>>(){

            public void accept(Event<IN> ev) {
                consumer.accept(ev.getData());
            }
        });
        return this;
    }

    @Override
    public NetChannel<IN, OUT> receive(final Function<IN, OUT> fn) {
        this.consume(new Consumer<IN>(){

            public void accept(IN in) {
                AbstractNetChannel.this.send(fn.apply(in));
            }
        });
        return this;
    }

    @Override
    public NetChannel<IN, OUT> send(Stream<OUT> data) {
        data.consume(new Consumer<OUT>(){

            public void accept(OUT out) {
                AbstractNetChannel.this.send(out, null);
            }
        });
        return this;
    }

    @Override
    public Promise<Void> send(OUT data) {
        Deferred d = Promises.defer((Environment)this.env, (Dispatcher)this.eventsReactor.getDispatcher());
        this.send(data, (Deferred<Void, Promise<Void>>)d);
        return (Promise)d.compose();
    }

    @Override
    public NetChannel<IN, OUT> sendAndForget(OUT data) {
        this.send(data, null);
        return this;
    }

    @Override
    public Promise<IN> sendAndReceive(OUT data) {
        Deferred d = Promises.defer((Environment)this.env, (Dispatcher)this.eventsReactor.getDispatcher());
        Selector sel = Selectors.$();
        this.eventsReactor.on(sel, (Consumer)new EventConsumer((Consumer)d)).cancelAfterUse();
        this.replyToKeys.add(sel.getObject());
        this.send(data, null);
        return (Promise)d.compose();
    }

    @Override
    public Promise<Boolean> close() {
        Deferred d = Promises.defer((Environment)this.getEnvironment(), (Dispatcher)this.eventsReactor.getDispatcher());
        this.eventsReactor.getConsumerRegistry().unregister(this.read.getObject());
        this.close((Consumer<Boolean>)d);
        return (Promise)d.compose();
    }

    protected void send(OUT data, Deferred<Void, Promise<Void>> onComplete) {
        this.ioReactor.schedule((Consumer)new WriteConsumer(onComplete), data);
    }

    public boolean read(Buffer data) {
        if (null != this.decoder && null != data.byteBuffer()) {
            this.decoder.apply((Object)data);
        } else {
            this.eventsReactor.notify(this.read.getObject(), Event.wrap((Object)data));
        }
        return data.remaining() > 0;
    }

    public void notifyRead(Object obj) {
        this.eventsReactor.notify(this.read.getObject(), Event.class.isInstance(obj) ? (Event)obj : Event.wrap((Object)obj));
    }

    public void notifyError(Throwable throwable) {
        this.eventsReactor.notify(throwable.getClass(), Event.wrap((Object)throwable));
    }

    protected void write(Buffer data, Deferred<Void, Promise<Void>> onComplete, boolean flush) {
        this.write(data.byteBuffer(), onComplete, flush);
    }

    protected abstract void write(ByteBuffer var1, Deferred<Void, Promise<Void>> var2, boolean var3);

    protected abstract void write(Object var1, Deferred<Void, Promise<Void>> var2, boolean var3);

    protected abstract void flush();

    protected Environment getEnvironment() {
        return this.env;
    }

    protected Reactor getEventsReactor() {
        return this.eventsReactor;
    }

    protected Reactor getIoReactor() {
        return this.ioReactor;
    }

    private final class WriteConsumer
    implements BatchConsumer<OUT> {
        private final Deferred<Void, Promise<Void>> onComplete;
        private volatile boolean autoflush = true;

        private WriteConsumer(Deferred<Void, Promise<Void>> onComplete) {
            this.onComplete = onComplete;
        }

        public void start() {
            this.autoflush = false;
        }

        public void end() {
            AbstractNetChannel.this.flush();
            this.autoflush = true;
        }

        public void accept(OUT data) {
            block7: {
                try {
                    if (null != AbstractNetChannel.this.encoder) {
                        Buffer bytes = (Buffer)AbstractNetChannel.this.encoder.apply(data);
                        if (bytes.remaining() > 0) {
                            AbstractNetChannel.this.write(bytes, this.onComplete, this.autoflush);
                        }
                    } else if (Buffer.class.isInstance(data)) {
                        AbstractNetChannel.this.write((Buffer)data, this.onComplete, this.autoflush);
                    } else {
                        AbstractNetChannel.this.write(data, this.onComplete, this.autoflush);
                    }
                }
                catch (Throwable t) {
                    AbstractNetChannel.this.eventsReactor.notify(t.getClass(), Event.wrap((Object)t));
                    if (null == this.onComplete) break block7;
                    this.onComplete.accept(t);
                }
            }
        }
    }
}

