/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.config;

import java.io.File;
import javax.net.ssl.TrustManager;
import reactor.function.Supplier;
import reactor.util.Assert;

public class SslOptions {
    private File keystoreFile;
    private String keystorePasswd;
    private String keyManagerPasswd;
    private String keyManagerFactoryAlgorithm = "SunX509";
    private Supplier<TrustManager[]> trustManagers;
    private String trustManagerPasswd;
    private String trustManagerFactoryAlgorithm = "SunX509";
    private String sslProtocol = "TLS";

    public String keystoreFile() {
        return null != this.keystoreFile ? this.keystoreFile.getPath() : null;
    }

    public SslOptions keystoreFile(String keystoreFile) {
        this.keystoreFile = new File(keystoreFile);
        Assert.isTrue((boolean)this.keystoreFile.exists(), (String)("No keystore file found at path " + this.keystoreFile.getAbsolutePath()));
        return this;
    }

    public String keystorePasswd() {
        return this.keystorePasswd;
    }

    public SslOptions keystorePasswd(String keystorePasswd) {
        this.keystorePasswd = keystorePasswd;
        return this;
    }

    public String keyManagerPasswd() {
        return this.keyManagerPasswd;
    }

    public SslOptions keyManagerPasswd(String keyManagerPasswd) {
        this.keyManagerPasswd = keyManagerPasswd;
        return this;
    }

    public String keyManagerFactoryAlgorithm() {
        return this.keyManagerFactoryAlgorithm;
    }

    public SslOptions keyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
        Assert.notNull((Object)keyManagerFactoryAlgorithm, (String)"KeyManagerFactory algorithm cannot be null");
        this.keyManagerFactoryAlgorithm = keyManagerFactoryAlgorithm;
        return this;
    }

    public String trustManagerPasswd() {
        return this.trustManagerPasswd;
    }

    public SslOptions trustManagerPasswd(String trustManagerPasswd) {
        this.trustManagerPasswd = trustManagerPasswd;
        return this;
    }

    public Supplier<TrustManager[]> trustManagers() {
        return this.trustManagers;
    }

    public SslOptions trustManagers(Supplier<TrustManager[]> trustManagers) {
        this.trustManagers = trustManagers;
        return this;
    }

    public String trustManagerFactoryAlgorithm() {
        return this.trustManagerFactoryAlgorithm;
    }

    public SslOptions trustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
        Assert.notNull((Object)trustManagerFactoryAlgorithm, (String)"TrustManagerFactory algorithm cannot be null");
        this.trustManagerFactoryAlgorithm = trustManagerFactoryAlgorithm;
        return this;
    }

    public String sslProtocol() {
        return this.sslProtocol;
    }

    public SslOptions sslProtocol(String sslProtocol) {
        Assert.notNull((Object)sslProtocol, (String)"SSL protocol cannot be null");
        this.sslProtocol = sslProtocol;
        return this;
    }
}

