/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.netty;

import io.netty.channel.EventLoop;
import java.util.concurrent.TimeUnit;
import reactor.event.dispatch.AbstractLifecycleDispatcher;
import reactor.event.dispatch.AbstractMultiThreadDispatcher;

public class NettyEventLoopDispatcher
extends AbstractMultiThreadDispatcher {
    private final EventLoop eventLoop;

    public NettyEventLoopDispatcher(EventLoop eventLoop, int backlog) {
        super(1, backlog);
        this.eventLoop = eventLoop;
    }

    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            return this.eventLoop.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void shutdown() {
        this.eventLoop.shutdownGracefully();
        super.shutdown();
    }

    public void halt() {
        this.eventLoop.shutdownGracefully();
        super.halt();
    }

    protected void execute(AbstractLifecycleDispatcher.Task task) {
        this.eventLoop.execute((Runnable)task);
    }

    public void execute(Runnable command) {
        this.eventLoop.execute(command);
    }
}

