/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Deferred;
import reactor.core.composable.Promise;
import reactor.event.Event;
import reactor.event.dispatch.Dispatcher;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.AbstractNetChannel;
import reactor.net.NetChannel;
import reactor.tuple.Tuple;

public class NettyNetChannel<IN, OUT>
extends AbstractNetChannel<IN, OUT> {
    private final Channel ioChannel;
    private volatile boolean closing = false;

    public NettyNetChannel(@Nonnull Environment env, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Dispatcher ioDispatcher, @Nonnull Reactor eventsReactor, @Nonnull Channel ioChannel) {
        super(env, codec, ioDispatcher, eventsReactor);
        this.ioChannel = ioChannel;
    }

    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.ioChannel.remoteAddress();
    }

    @Override
    public void close(final @Nullable Consumer<Boolean> onClose) {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.ioChannel.close().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (null != onClose) {
                    NettyNetChannel.this.getEventsReactor().schedule(onClose, (Object)future.isSuccess());
                } else if (!future.isSuccess()) {
                    NettyNetChannel.this.log.error(future.cause().getMessage(), future.cause());
                }
                NettyNetChannel.this.closing = false;
            }
        });
    }

    @Override
    public NetChannel.ConsumerSpec on() {
        return new NettyConsumerSpec();
    }

    @Override
    protected void write(ByteBuffer data, Deferred<Void, Promise<Void>> onComplete, boolean flush) {
        ByteBuf buf = this.ioChannel.alloc().buffer(data.remaining());
        buf.writeBytes(data);
        this.write(buf, onComplete, flush);
    }

    @Override
    protected void write(Object data, final Deferred<Void, Promise<Void>> onComplete, boolean flush) {
        ChannelFuture writeFuture = this.ioChannel.write((Object)Tuple.of((Object)data, (Object)flush));
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                boolean success = future.isSuccess();
                if (!success) {
                    Throwable t = future.cause();
                    NettyNetChannel.this.getEventsReactor().notify(t.getClass(), Event.wrap((Object)t));
                    if (null != onComplete) {
                        onComplete.accept(t);
                    }
                } else if (null != onComplete) {
                    onComplete.accept((Object)null);
                }
            }
        });
    }

    @Override
    protected void flush() {
        this.ioChannel.write((Object)Tuple.of(null, (Object)true));
    }

    public String toString() {
        return "NettyNetChannel{channel=" + this.ioChannel + '}';
    }

    private class NettyConsumerSpec
    implements NetChannel.ConsumerSpec {
        private NettyConsumerSpec() {
        }

        @Override
        public NetChannel.ConsumerSpec close(final Runnable onClose) {
            NettyNetChannel.this.ioChannel.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    onClose.run();
                    super.channelInactive(ctx);
                }
            }});
            return this;
        }

        @Override
        public NetChannel.ConsumerSpec readIdle(long idleTimeout, final Runnable onReadIdle) {
            NettyNetChannel.this.ioChannel.pipeline().addFirst(new ChannelHandler[]{new IdleStateHandler(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS){

                protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
                    if (evt.state() == IdleState.READER_IDLE) {
                        onReadIdle.run();
                    }
                    super.channelIdle(ctx, evt);
                }
            }});
            return this;
        }

        @Override
        public NetChannel.ConsumerSpec writeIdle(long idleTimeout, final Runnable onWriteIdle) {
            NettyNetChannel.this.ioChannel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, idleTimeout, 0L, TimeUnit.MILLISECONDS){

                protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
                    if (evt.state() == IdleState.WRITER_IDLE) {
                        onWriteIdle.run();
                    }
                    super.channelIdle(ctx, evt);
                }
            }});
            return this;
        }
    }
}

