/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.netty.tcp;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Deferred;
import reactor.core.composable.Promise;
import reactor.core.composable.spec.Promises;
import reactor.event.dispatch.Dispatcher;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.AbstractNetChannel;
import reactor.net.NetChannel;
import reactor.net.config.ServerSocketOptions;
import reactor.net.config.SslOptions;
import reactor.net.netty.NettyEventLoopDispatcher;
import reactor.net.netty.NettyNetChannel;
import reactor.net.netty.NettyNetChannelInboundHandler;
import reactor.net.netty.NettyNetChannelOutboundHandler;
import reactor.net.netty.NettyServerSocketOptions;
import reactor.net.tcp.TcpServer;
import reactor.net.tcp.ssl.SSLEngineSupplier;
import reactor.support.NamedDaemonThreadFactory;

public class NettyTcpServer<IN, OUT>
extends TcpServer<IN, OUT> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NettyServerSocketOptions nettyOptions;
    private final ServerBootstrap bootstrap;
    private final EventLoopGroup selectorGroup;
    private final EventLoopGroup ioGroup;

    protected NettyTcpServer(@Nonnull Environment env, @Nonnull Reactor reactor, @Nullable InetSocketAddress listenAddress, final ServerSocketOptions options, final SslOptions sslOptions, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Collection<Consumer<NetChannel<IN, OUT>>> consumers) {
        super(env, reactor, listenAddress, options, sslOptions, codec, consumers);
        this.nettyOptions = options instanceof NettyServerSocketOptions ? (NettyServerSocketOptions)options : null;
        int selectThreadCount = (Integer)env.getProperty("reactor.tcp.selectThreadCount", Integer.class, (Object)(Environment.PROCESSORS / 2));
        int ioThreadCount = (Integer)env.getProperty("reactor.tcp.ioThreadCount", Integer.class, (Object)Environment.PROCESSORS);
        this.selectorGroup = new NioEventLoopGroup(selectThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-tcp-select"));
        this.ioGroup = null != this.nettyOptions && null != this.nettyOptions.eventLoopGroup() ? this.nettyOptions.eventLoopGroup() : new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedDaemonThreadFactory("reactor-tcp-io"));
        this.bootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.selectorGroup, this.ioGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)options.backlog())).option(ChannelOption.SO_RCVBUF, (Object)options.rcvbuf())).option(ChannelOption.SO_SNDBUF, (Object)options.sndbuf())).option(ChannelOption.SO_REUSEADDR, (Object)options.reuseAddr())).localAddress((SocketAddress)(null == listenAddress ? new InetSocketAddress(3000) : listenAddress))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(final SocketChannel ch) throws Exception {
                SocketChannelConfig config = ch.config();
                config.setReceiveBufferSize(options.rcvbuf());
                config.setSendBufferSize(options.sndbuf());
                config.setKeepAlive(options.keepAlive());
                config.setReuseAddress(options.reuseAddr());
                config.setSoLinger(options.linger());
                config.setTcpNoDelay(options.tcpNoDelay());
                if (NettyTcpServer.this.log.isDebugEnabled()) {
                    NettyTcpServer.this.log.debug("CONNECT {}", (Object)ch);
                }
                if (null != sslOptions) {
                    SSLEngine ssl = new SSLEngineSupplier(sslOptions, false).get();
                    if (NettyTcpServer.this.log.isDebugEnabled()) {
                        NettyTcpServer.this.log.debug("SSL enabled using keystore {}", (Object)(null != sslOptions.keystoreFile() ? sslOptions.keystoreFile() : "<DEFAULT>"));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(ssl)});
                }
                if (null != NettyTcpServer.this.nettyOptions && null != NettyTcpServer.this.nettyOptions.pipelineConfigurer()) {
                    NettyTcpServer.this.nettyOptions.pipelineConfigurer().accept((Object)ch.pipeline());
                }
                ch.pipeline().addLast(NettyTcpServer.this.createChannelHandlers(ch));
                ch.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (NettyTcpServer.this.log.isDebugEnabled()) {
                            NettyTcpServer.this.log.debug("CLOSE {}", (Object)ch);
                        }
                        NettyTcpServer.this.close(ch);
                    }
                });
            }
        });
    }

    @Override
    public TcpServer<IN, OUT> start(final @Nullable Runnable started) {
        ChannelFuture bindFuture = this.bootstrap.bind();
        if (null != started) {
            bindFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyTcpServer.this.log.info("BIND {}", (Object)future.channel().localAddress());
                    NettyTcpServer.this.notifyStart(started);
                }
            });
        }
        return this;
    }

    @Override
    public Promise<Boolean> shutdown() {
        final Deferred d = Promises.defer((Environment)this.getEnvironment(), (Dispatcher)this.getReactor().getDispatcher());
        this.getReactor().schedule((Consumer)new Consumer<Void>(){

            public void accept(Void v) {
                final AtomicInteger groupsToShutdown = new AtomicInteger(2);
                GenericFutureListener listener = new GenericFutureListener(){

                    public void operationComplete(Future future) throws Exception {
                        if (groupsToShutdown.decrementAndGet() == 0) {
                            NettyTcpServer.this.notifyShutdown();
                            d.accept((Object)true);
                        }
                    }
                };
                NettyTcpServer.this.selectorGroup.shutdownGracefully().addListener(listener);
                if (null == NettyTcpServer.this.nettyOptions || null == NettyTcpServer.this.nettyOptions.eventLoopGroup()) {
                    NettyTcpServer.this.ioGroup.shutdownGracefully().addListener(listener);
                }
            }
        }, null);
        return (Promise)d.compose();
    }

    @Override
    protected <C> NetChannel<IN, OUT> createChannel(C ioChannel) {
        return new NettyNetChannel(this.getEnvironment(), this.getCodec(), (Dispatcher)new NettyEventLoopDispatcher(((Channel)ioChannel).eventLoop(), 256), this.getReactor(), (Channel)ioChannel);
    }

    protected ChannelHandler[] createChannelHandlers(SocketChannel ch) {
        AbstractNetChannel netChannel = (AbstractNetChannel)this.select(ch);
        NettyNetChannelInboundHandler readHandler = new NettyNetChannelInboundHandler().setNetChannel(netChannel);
        NettyNetChannelOutboundHandler writeHandler = new NettyNetChannelOutboundHandler();
        return new ChannelHandler[]{readHandler, writeHandler};
    }
}

