/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.spec;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import reactor.core.spec.support.EventRoutingComponentSpec;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.NetChannel;
import reactor.net.NetServer;
import reactor.net.config.ServerSocketOptions;
import reactor.util.Assert;

public abstract class NetServerSpec<IN, OUT, S extends NetServerSpec<IN, OUT, S, N>, N extends NetServer<IN, OUT>>
extends EventRoutingComponentSpec<S, N> {
    protected ServerSocketOptions options = new ServerSocketOptions();
    protected Collection<Consumer<NetChannel<IN, OUT>>> channelConsumers = Collections.emptyList();
    protected InetSocketAddress listenAddress;
    protected Codec<Buffer, IN, OUT> codec;

    public S options(@Nonnull ServerSocketOptions options) {
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null.");
        this.options = options;
        return (S)((Object)this);
    }

    public S listen(int port) {
        return this.listen(new InetSocketAddress(port));
    }

    public S listen(String host, int port) {
        if (null == host) {
            host = "localhost";
        }
        return this.listen(new InetSocketAddress(host, port));
    }

    public S listen(InetSocketAddress listenAddress) {
        this.listenAddress = listenAddress;
        return (S)((Object)this);
    }

    public S codec(@Nonnull Codec<Buffer, IN, OUT> codec) {
        Assert.notNull(codec, (String)"Codec cannot be null.");
        this.codec = codec;
        return (S)((Object)this);
    }

    public S consumeInput(final @Nonnull Consumer<IN> inputConsumer) {
        List<Consumer<NetChannel<IN, OUT>>> channelConsumers = Collections.singletonList(new Consumer<NetChannel<IN, OUT>>(){

            public void accept(NetChannel<IN, OUT> channel) {
                channel.consume(inputConsumer);
            }
        });
        return this.consume(channelConsumers);
    }

    public S consume(@Nonnull Consumer<NetChannel<IN, OUT>> channelConsumer) {
        return this.consume(Collections.singletonList(channelConsumer));
    }

    public S consume(@Nonnull Collection<Consumer<NetChannel<IN, OUT>>> channelConsumers) {
        Assert.notNull(channelConsumers, (String)"Connection consumers cannot be null.");
        this.channelConsumers = channelConsumers;
        return (S)((Object)this);
    }
}

