/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.tcp;

import java.net.InetSocketAddress;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Promise;
import reactor.core.composable.Stream;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.AbstractNetPeer;
import reactor.net.NetChannel;
import reactor.net.NetClient;
import reactor.net.Reconnect;
import reactor.net.config.ClientSocketOptions;
import reactor.net.config.SslOptions;

public abstract class TcpClient<IN, OUT>
extends AbstractNetPeer<IN, OUT>
implements NetClient<IN, OUT> {
    private final InetSocketAddress connectAddress;
    private final ClientSocketOptions options;
    private final SslOptions sslOptions;

    protected TcpClient(@Nonnull Environment env, @Nonnull Reactor reactor, @Nullable InetSocketAddress connectAddress, @Nullable ClientSocketOptions options, @Nullable SslOptions sslOptions, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Collection<Consumer<NetChannel<IN, OUT>>> consumers) {
        super(env, reactor, codec, consumers);
        this.connectAddress = null != connectAddress ? connectAddress : new InetSocketAddress("127.0.0.1", 3000);
        this.options = options;
        this.sslOptions = sslOptions;
    }

    @Override
    public abstract Promise<NetChannel<IN, OUT>> open();

    @Override
    public abstract Stream<NetChannel<IN, OUT>> open(Reconnect var1);

    public InetSocketAddress getConnectAddress() {
        return this.connectAddress;
    }

    protected ClientSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

