/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.tcp;

import java.net.InetSocketAddress;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Deferred;
import reactor.core.composable.Promise;
import reactor.core.composable.spec.Promises;
import reactor.event.dispatch.Dispatcher;
import reactor.function.Consumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.AbstractNetPeer;
import reactor.net.NetChannel;
import reactor.net.NetServer;
import reactor.net.config.ServerSocketOptions;
import reactor.net.config.SslOptions;
import reactor.util.Assert;

public abstract class TcpServer<IN, OUT>
extends AbstractNetPeer<IN, OUT>
implements NetServer<IN, OUT> {
    private final InetSocketAddress listenAddress;
    private final ServerSocketOptions options;
    private final SslOptions sslOptions;

    protected TcpServer(@Nonnull Environment env, @Nonnull Reactor reactor, @Nullable InetSocketAddress listenAddress, ServerSocketOptions options, SslOptions sslOptions, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Collection<Consumer<NetChannel<IN, OUT>>> consumers) {
        super(env, reactor, codec, consumers);
        this.listenAddress = listenAddress;
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null");
        this.options = options;
        this.sslOptions = sslOptions;
    }

    @Override
    public Promise<Boolean> start() {
        final Deferred d = Promises.defer((Environment)this.getEnvironment(), (Dispatcher)this.getReactor().getDispatcher());
        this.start(new Runnable(){

            @Override
            public void run() {
                d.accept((Object)true);
            }
        });
        return (Promise)d.compose();
    }

    @Override
    public abstract TcpServer<IN, OUT> start(@Nullable Runnable var1);

    protected InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    protected ServerSocketOptions getOptions() {
        return this.options;
    }

    protected SslOptions getSslOptions() {
        return this.sslOptions;
    }
}

