/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.tcp.spec;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import reactor.function.Supplier;
import reactor.function.Suppliers;
import reactor.net.Reconnect;
import reactor.tuple.Tuple;
import reactor.tuple.Tuple2;

public class IncrementalBackoffReconnectSpec
implements Supplier<Reconnect> {
    public static final long DEFAULT_INTERVAL = 5000L;
    public static final long DEFAULT_MULTIPLIER = 1L;
    public static final long DEFAULT_MAX_ATTEMPTS = -1L;
    private final List<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
    private long interval = 5000L;
    private long multiplier = 1L;
    private long maxInterval = Long.MAX_VALUE;
    private long maxAttempts = -1L;

    public IncrementalBackoffReconnectSpec interval(long interval) {
        this.interval = interval;
        return this;
    }

    public IncrementalBackoffReconnectSpec maxInterval(long maxInterval) {
        this.maxInterval = maxInterval;
        return this;
    }

    public IncrementalBackoffReconnectSpec multiplier(long multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    public IncrementalBackoffReconnectSpec maxAttempts(long maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public IncrementalBackoffReconnectSpec address(InetSocketAddress address) {
        this.addresses.add(address);
        return this;
    }

    public IncrementalBackoffReconnectSpec address(String host, int port) {
        this.addresses.add(new InetSocketAddress(host, port));
        return this;
    }

    public Reconnect get() {
        final Supplier endpoints = Suppliers.roundRobin((Object[])this.addresses.toArray(new InetSocketAddress[0]));
        return new Reconnect(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Tuple2<InetSocketAddress, Long> reconnect(InetSocketAddress currentAddress, int attempt) {
                Tuple2 rv = null;
                IncrementalBackoffReconnectSpec incrementalBackoffReconnectSpec = IncrementalBackoffReconnectSpec.this;
                synchronized (incrementalBackoffReconnectSpec) {
                    if (!IncrementalBackoffReconnectSpec.this.addresses.isEmpty()) {
                        if (IncrementalBackoffReconnectSpec.this.maxAttempts == -1L || IncrementalBackoffReconnectSpec.this.maxAttempts > (long)attempt) {
                            rv = Tuple.of((Object)endpoints.get(), (Object)IncrementalBackoffReconnectSpec.this.determineInterval(attempt));
                        }
                    } else {
                        rv = Tuple.of((Object)currentAddress, (Object)IncrementalBackoffReconnectSpec.this.determineInterval(attempt));
                    }
                }
                return rv;
            }
        };
    }

    public long determineInterval(int attempt) {
        return this.multiplier > 1L ? Math.min(this.maxInterval, this.interval * (long)attempt) : this.interval;
    }
}

