/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.tcp.spec;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.io.encoding.Codec;
import reactor.net.config.ServerSocketOptions;
import reactor.net.config.SslOptions;
import reactor.net.spec.NetServerSpec;
import reactor.net.tcp.TcpServer;
import reactor.util.Assert;

public class TcpServerSpec<IN, OUT>
extends NetServerSpec<IN, OUT, TcpServerSpec<IN, OUT>, TcpServer<IN, OUT>> {
    private final Constructor<? extends TcpServer> serverImplConstructor;
    private SslOptions sslOptions = null;

    public TcpServerSpec(@Nonnull Class<? extends TcpServer> serverImpl) {
        Assert.notNull(serverImpl, (String)"TcpServer implementation class cannot be null.");
        try {
            this.serverImplConstructor = serverImpl.getDeclaredConstructor(Environment.class, Reactor.class, InetSocketAddress.class, ServerSocketOptions.class, SslOptions.class, Codec.class, Collection.class);
            this.serverImplConstructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No public constructor found that matches the signature of the one found in the TcpServer class.");
        }
    }

    public TcpServerSpec<IN, OUT> ssl(@Nullable SslOptions sslOptions) {
        this.sslOptions = sslOptions;
        return this;
    }

    protected TcpServer<IN, OUT> configure(Reactor reactor, Environment env) {
        try {
            return this.serverImplConstructor.newInstance(env, reactor, this.listenAddress, this.options, this.sslOptions, this.codec, this.channelConsumers);
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }
}

