/*
 * Decompiled with CFR 0.152.
 */
package reactor.net.udp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Environment;
import reactor.core.Reactor;
import reactor.core.composable.Deferred;
import reactor.core.composable.Promise;
import reactor.core.composable.Stream;
import reactor.core.composable.spec.Promises;
import reactor.event.dispatch.Dispatcher;
import reactor.function.Consumer;
import reactor.function.batch.BatchConsumer;
import reactor.io.Buffer;
import reactor.io.encoding.Codec;
import reactor.net.AbstractNetPeer;
import reactor.net.NetChannel;
import reactor.net.NetServer;
import reactor.net.config.ServerSocketOptions;
import reactor.util.Assert;

public abstract class DatagramServer<IN, OUT>
extends AbstractNetPeer<IN, OUT>
implements NetServer<IN, OUT> {
    private final InetSocketAddress listenAddress;
    private final NetworkInterface multicastInterface;
    private final ServerSocketOptions options;

    protected DatagramServer(@Nonnull Environment env, @Nonnull Reactor reactor, @Nullable InetSocketAddress listenAddress, @Nullable NetworkInterface multicastInterface, @Nonnull ServerSocketOptions options, @Nullable Codec<Buffer, IN, OUT> codec, @Nonnull Collection<Consumer<NetChannel<IN, OUT>>> consumers) {
        super(env, reactor, codec, consumers);
        Assert.notNull((Object)options, (String)"ServerSocketOptions cannot be null");
        this.listenAddress = listenAddress;
        this.multicastInterface = multicastInterface;
        this.options = options;
    }

    @Override
    public Promise<Boolean> start() {
        final Deferred d = Promises.defer((Environment)this.getEnvironment(), (Dispatcher)this.getReactor().getDispatcher());
        this.start(new Runnable(){

            @Override
            public void run() {
                d.accept((Object)true);
            }
        });
        return (Promise)d.compose();
    }

    @Override
    public abstract DatagramServer<IN, OUT> start(@Nullable Runnable var1);

    public abstract DatagramServer<IN, OUT> send(OUT var1);

    public abstract Stream<IN> in();

    public abstract BatchConsumer<OUT> out();

    public abstract Promise<Void> join(InetAddress var1, NetworkInterface var2);

    public Promise<Void> join(InetAddress multicastAddress) {
        return this.join(multicastAddress, null);
    }

    public abstract Promise<Void> leave(InetAddress var1, NetworkInterface var2);

    public Promise<Void> leave(InetAddress multicastAddress) {
        return this.leave(multicastAddress, null);
    }

    protected InetSocketAddress getListenAddress() {
        return this.listenAddress;
    }

    protected NetworkInterface getMulticastInterface() {
        return this.multicastInterface;
    }

    protected ServerSocketOptions getOptions() {
        return this.options;
    }
}

