/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.jcajce.provider.asymmetric.ec;

import java.security.spec.ECGenParameterSpec;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.x9.X9ECParameters;
import org.python.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;

class ECUtils {
    ECUtils() {
    }

    static X9ECParameters getDomainParametersFromGenSpec(ECGenParameterSpec eCGenParameterSpec) {
        return ECUtils.getDomainParametersFromName(eCGenParameterSpec.getName());
    }

    static X9ECParameters getDomainParametersFromName(String string2) {
        X9ECParameters x9ECParameters;
        try {
            if (string2.charAt(0) >= '0' && string2.charAt(0) <= '2') {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string2);
                x9ECParameters = ECUtil.getNamedCurveByOid(aSN1ObjectIdentifier);
            } else if (string2.indexOf(32) > 0) {
                string2 = string2.substring(string2.indexOf(32) + 1);
                x9ECParameters = ECUtil.getNamedCurveByName(string2);
            } else {
                x9ECParameters = ECUtil.getNamedCurveByName(string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            x9ECParameters = ECUtil.getNamedCurveByName(string2);
        }
        return x9ECParameters;
    }
}

