/*
 * Decompiled with CFR 0.152.
 */
package shaded.netty.channel.socket.oio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import shaded.netty.channel.AbstractChannel;
import shaded.netty.channel.Channel;
import shaded.netty.channel.ChannelFactory;
import shaded.netty.channel.ChannelFuture;
import shaded.netty.channel.ChannelPipeline;
import shaded.netty.channel.ChannelSink;
import shaded.netty.channel.socket.Worker;

abstract class AbstractOioChannel
extends AbstractChannel {
    private volatile InetSocketAddress localAddress;
    volatile InetSocketAddress remoteAddress;
    volatile Thread workerThread;
    volatile Worker worker;
    final Object interestOpsLock = new Object();

    AbstractOioChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(parent, factory, pipeline, sink);
    }

    protected boolean setClosed() {
        return super.setClosed();
    }

    protected int getInternalInterestOps() {
        return super.getInternalInterestOps();
    }

    protected void setInternalInterestOps(int interestOps) {
        super.setInternalInterestOps(interestOps);
    }

    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return super.write(message, remoteAddress);
    }

    public boolean isBound() {
        return this.isOpen() && this.isSocketBound();
    }

    public boolean isConnected() {
        return this.isOpen() && this.isSocketConnected();
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = this.getLocalSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    abstract boolean isSocketBound();

    abstract boolean isSocketConnected();

    abstract boolean isSocketClosed();

    abstract InetSocketAddress getLocalSocketAddress() throws Exception;

    abstract InetSocketAddress getRemoteSocketAddress() throws Exception;

    abstract void closeSocket() throws IOException;
}

